package com.yandex.burp.extensions.plugins.grep;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

import burp.IBurpExtenderCallbacks;
import burp.IExtensionHelpers;
import burp.IHttpRequestResponse;
import burp.IResponseInfo;
import burp.IScanIssue;
import com.yandex.burp.extensions.plugins.CustomScanIssue;
import com.yandex.burp.extensions.plugins.config.BurpMollyPackConfig;


public class BlackBoxLeakPlugin implements IGrepPlugin {

    private IBurpExtenderCallbacks callbacks;
    private IExtensionHelpers helpers;

    private static final Pattern BlackboxPattern = Pattern.compile("^(?=.*userticket|user_ticket)(?=.*have_password)(?=.*VALID).*");

    private final int ISSUE_TYPE = 0x080a000f;
    private final String ISSUE_NAME = "Leak Blackbox response";
    private final String SEVERITY = "Medium";
    private final String CONFIDENCE = "Certain";

    public BlackBoxLeakPlugin(IBurpExtenderCallbacks callbacks, BurpMollyPackConfig extConfig) {
        this.callbacks = callbacks;
        this.helpers = callbacks.getHelpers();
    }

    @Override
    public IScanIssue grep(IHttpRequestResponse baseRequestResponse) {
        IResponseInfo resp = helpers.analyzeResponse(baseRequestResponse.getResponse());
        if (resp == null) return null;

        String body = helpers.bytesToString(baseRequestResponse.getResponse());
        Matcher matcher = BlackboxPattern.matcher(body);

        if (matcher.find()) {
            String issueDetails = "The URL <b> " + helpers.analyzeRequest(baseRequestResponse).getUrl().toString() +
                    "</b>\n" + "leak a Blackbox response";

            return new CustomScanIssue(baseRequestResponse.getHttpService(),
                    helpers.analyzeRequest(baseRequestResponse).getUrl(),
                    new IHttpRequestResponse[]{this.callbacks.applyMarkers(baseRequestResponse, null, null)},
                    issueDetails, ISSUE_TYPE, ISSUE_NAME, SEVERITY, CONFIDENCE,
                    "", "", "");
        }

        return null;
    }
}
