package com.yandex.burp.extensions.plugins.grep;

import java.net.URL;

import burp.IBurpExtenderCallbacks;
import burp.IExtensionHelpers;
import burp.IHttpRequestResponse;
import burp.IRequestInfo;
import burp.IResponseInfo;
import burp.IScanIssue;
import com.yandex.burp.extensions.plugins.CustomScanIssue;
import com.yandex.burp.extensions.plugins.Utils;
import com.yandex.burp.extensions.plugins.config.BurpMollyPackConfig;


public class DirbusterPlugin implements IGrepPlugin {

    private IBurpExtenderCallbacks callbacks;
    private IExtensionHelpers helpers;

    private final int ISSUE_TYPE = 0x080a0010;
    private final String ISSUE_NAME = "Dirbuster";
    private final String SEVERITY = "Information";
    private final String CONFIDENCE = "Certain";
    private final int respLength = 3;

    public DirbusterPlugin(IBurpExtenderCallbacks callbacks, BurpMollyPackConfig extConfig) {
        this.callbacks = callbacks;
        this.helpers = callbacks.getHelpers();
    }

    @Override
    public IScanIssue grep(IHttpRequestResponse baseRequestResponse) {
        IResponseInfo resp = helpers.analyzeResponse(baseRequestResponse.getResponse());
        if (resp == null) return null;

        IRequestInfo req = helpers.analyzeRequest(baseRequestResponse.getRequest());
        if (Utils.getHeaderValue(req, "X-Dirbuster-Code") == null) return null;

        // Break GET / HTTP/1.1 Request
        URL url = helpers.analyzeRequest(baseRequestResponse).getUrl();
        if (url.getPath().equals("/")) return null;

        Short statusCode = Short.parseShort(Utils.getHeaderValue(req, "X-Dirbuster-Code"));
        String respBody = helpers.bytesToString(baseRequestResponse.getResponse()).substring(resp.getBodyOffset());

        if (resp.getStatusCode() == statusCode && respBody.length() > respLength) {
            String issueDetails = "The URL <b> " + helpers.analyzeRequest(baseRequestResponse).getUrl().toString() +
                    "</b>\n" + "from DirbusterPlugin returns " + statusCode.toString() + " response code.";

            return new CustomScanIssue(baseRequestResponse.getHttpService(),
                    helpers.analyzeRequest(baseRequestResponse).getUrl(),
                    new IHttpRequestResponse[]{this.callbacks.applyMarkers(baseRequestResponse, null, null)},
                    issueDetails, ISSUE_TYPE, ISSUE_NAME, SEVERITY, CONFIDENCE,
                    "", "", "");
        }
        return null;
    }
}
