package com.yandex.burp.extensions.plugins.grep;

import java.util.List;

import burp.IBurpExtenderCallbacks;
import burp.IExtensionHelpers;
import burp.IHttpRequestResponse;
import burp.IResponseInfo;
import burp.IScanIssue;
import com.yandex.burp.extensions.plugins.CustomScanIssue;
import com.yandex.burp.extensions.plugins.config.BurpMollyPackConfig;
import com.yandex.burp.extensions.plugins.config.DisplayNameXssPluginConfig;

public class DisplayNameXssPlugin implements IGrepPlugin {
    private List<String> xssNames;
    private IBurpExtenderCallbacks callbacks;
    private IExtensionHelpers helpers;

    private final int ISSUE_TYPE = 0x080a000f;
    private final String ISSUE_NAME = "Display_name is not encoded in response";
    private final String SEVERITY = "Medium";
    private final String CONFIDENCE = "Certain";

    public DisplayNameXssPlugin(IBurpExtenderCallbacks callbacks, BurpMollyPackConfig extConfig) {
        DisplayNameXssPluginConfig config = extConfig.getDisplayNameXssPluginConfig();

        if (config == null)
            throw new NullPointerException();

        this.xssNames = config.getMollyNames();
        this.callbacks = callbacks;
        this.helpers = callbacks.getHelpers();
    }

    @Override
    public IScanIssue grep(IHttpRequestResponse baseRequestResponse) {
        IResponseInfo resp = helpers.analyzeResponse(baseRequestResponse.getResponse());
        if (resp == null) return null;

        String body = helpers.bytesToString(baseRequestResponse.getResponse());
        for (String i : this.xssNames) {
            if (body.contains(i)) {
                String issueDetails = "The URL <b> " + helpers.analyzeRequest(baseRequestResponse).getUrl().toString() +
                        "</b>\n" + "does not encode or sanitize display_name";

                return new CustomScanIssue(baseRequestResponse.getHttpService(),
                        helpers.analyzeRequest(baseRequestResponse).getUrl(),
                        new IHttpRequestResponse[]{this.callbacks.applyMarkers(baseRequestResponse, null, null)},
                        issueDetails, ISSUE_TYPE, ISSUE_NAME, SEVERITY, CONFIDENCE,
                        "", "", "");
            }
        }

        return null;
    }
}
