package com.yandex.burp.extensions.plugins.grep;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

import burp.IBurpExtenderCallbacks;
import burp.IExtensionHelpers;
import burp.IHttpRequestResponse;
import burp.IResponseInfo;
import burp.IScanIssue;
import com.yandex.burp.extensions.plugins.CustomScanIssue;
import com.yandex.burp.extensions.plugins.config.BurpMollyPackConfig;


public class DjangoDebugPlugin implements IGrepPlugin {

    private IBurpExtenderCallbacks callbacks;
    private IExtensionHelpers helpers;

    private static final Pattern RespPattern = Pattern.compile("You're seeing this error because you have <code>DEBUG = True</code>");

    private final int ISSUE_TYPE = 0x080a000f;
    private final String ISSUE_NAME = "Django in DEBUG mode";
    private final String SEVERITY = "Medium";
    private final String CONFIDENCE = "Certain";

    public DjangoDebugPlugin(IBurpExtenderCallbacks callbacks, BurpMollyPackConfig extConfig) {
        this.callbacks = callbacks;
        this.helpers = callbacks.getHelpers();
    }

    @Override
    public IScanIssue grep(IHttpRequestResponse baseRequestResponse) {
        IResponseInfo resp = helpers.analyzeResponse(baseRequestResponse.getResponse());
        if (resp == null) return null;

        String body = helpers.bytesToString(baseRequestResponse.getResponse());
        Matcher matcher = RespPattern.matcher(body);

        if (matcher.find()) {
            String issueDetails = "The URL <b> " + helpers.analyzeRequest(baseRequestResponse).getUrl().toString() +
                    "</b>\n" + "has Django in DEBUG mode.";

            return new CustomScanIssue(baseRequestResponse.getHttpService(),
                    helpers.analyzeRequest(baseRequestResponse).getUrl(),
                    new IHttpRequestResponse[]{this.callbacks.applyMarkers(baseRequestResponse, null, null)},
                    issueDetails, ISSUE_TYPE, ISSUE_NAME, SEVERITY, CONFIDENCE,
                    "", "", "");
        }

        return null;
    }
}
