package com.yandex.burp.extensions.plugins.grep;

import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

import burp.IBurpExtenderCallbacks;
import burp.IExtensionHelpers;
import burp.IHttpRequestResponse;
import burp.IResponseInfo;
import burp.IScanIssue;
import com.yandex.burp.extensions.plugins.CustomScanIssue;
import com.yandex.burp.extensions.plugins.config.BurpMollyPackConfig;


public class SessionIdLeakPlugin implements IGrepPlugin {

    private IBurpExtenderCallbacks callbacks;
    private IExtensionHelpers helpers;

    // Session_id=3:1562674386.5.0.1539162850440:7u0yYBzicUUHIwAAuAYCKg:39.1|1120000000024341.0.2002|140128.914381.xxx;
    // sessionid2=3:1562674386.5.0.1539162850440:7u0yYBzicUUHIwAAuAYCKg:39.1|1120000000024341.0.2|140128.507372.yyy;

    private static final Pattern SessionIdPattern = Pattern.compile(
            "(session_id|sessionid2|sessionid|sslsessionid|sessguard)=([A-Za-z0-9_:|%.-]+)\\.([A-Za-z0-9_-]{27})",
            Pattern.CASE_INSENSITIVE
    );

    private static final int ISSUE_TYPE = 0x080a000f;
    private static final String ISSUE_NAME = "Leak SessionId response";
    private static final String SEVERITY = "Information";
    private static final String CONFIDENCE = "Certain";

    public SessionIdLeakPlugin(IBurpExtenderCallbacks callbacks, BurpMollyPackConfig extConfig) {
        this.callbacks = callbacks;
        this.helpers = callbacks.getHelpers();
    }

    @Override
    public IScanIssue grep(IHttpRequestResponse baseRequestResponse) {
        IResponseInfo resp = helpers.analyzeResponse(baseRequestResponse.getResponse());
        if (resp == null) return null;

        /* ignore just headers */
        if (helpers.bytesToString(baseRequestResponse.getResponse()).length() <= resp.getBodyOffset())
            return null;

        /* match body only */
        String body = helpers.bytesToString(baseRequestResponse.getResponse()).substring(resp.getBodyOffset());
        Matcher matcher = SessionIdPattern.matcher(body);

        if (matcher.find()) {
            String issueDetails = "The URL <b> " + helpers.analyzeRequest(baseRequestResponse).getUrl().toString() +
                    "</b>\n" + "leak a SessionId";

            List<int[]> responseMarkers = Collections.singletonList(new int[]{
                    matcher.start(),
                    matcher.end()
            });

            return new CustomScanIssue(baseRequestResponse.getHttpService(),
                    helpers.analyzeRequest(baseRequestResponse).getUrl(),
                    new IHttpRequestResponse[] {
                            this.callbacks.applyMarkers(baseRequestResponse, null, responseMarkers)
                    }, issueDetails, ISSUE_TYPE, ISSUE_NAME, SEVERITY, CONFIDENCE,
                    "", "", "");
        }

        return null;
    }
}

