import logging
from security.c3po.components.plugins import (
    AppsecDuty,
    AppsecDutyAssigner,
    #  BlockerConcealer,
    Bugbounty,
    CloudAlerts,
    CoreistParser,
    Csp,
    DpiaParser,
    GrantsReviewReviver,
    Pki,
    PuncherChecker,
    Secaudit,
    SecauditAutoapprover,
    SecauditCloser,
    SecauditImpulseIdm,
    SecauditReminder,
    Secduty,
    SecdutyLinker,
    Secreview,
    SecreviewMarket,
    Sectask,
    SectaskTicketReviver,
    SecurityAssessor,
    TaxiSecurity,
    VulnTicketEscalator,
    VulnTicketReporter,
    VulnTicketReviver,
    WebauthAlerts,
    Welcome,
    WelcomeRecruits,
    WelcomeRecruitsReminder,
    YcloudDockerRedeploy
)


def load_plugins(config, sentry):
    plugins_cls = [
        AppsecDuty,
        AppsecDutyAssigner,
        #  BlockerConcealer, requires special config
        Bugbounty,
        CloudAlerts,
        CoreistParser,
        Csp,
        DpiaParser,
        GrantsReviewReviver,
        Pki,
        PuncherChecker,
        Secaudit,
        SecauditAutoapprover,
        SecauditCloser,
        SecauditImpulseIdm,
        SecauditReminder,
        Secduty,
        SecdutyLinker,
        Secreview,
        SecreviewMarket,
        Sectask,
        SectaskTicketReviver,
        SecurityAssessor,
        TaxiSecurity,
        VulnTicketEscalator,
        VulnTicketReporter,
        VulnTicketReviver,
        WebauthAlerts,
        Welcome,
        WelcomeRecruits,
        WelcomeRecruitsReminder,
        YcloudDockerRedeploy
    ]
    prefix = 'plugins.'
    plugins_to_load = set()
    for section in config.sections():
        if section.startswith(prefix):
            plugins_to_load.add(
                section[len(prefix):].replace('_', '').lower()
            )
    plugins = []
    for cl in filter(lambda cl: cl.__name__.lower() in plugins_to_load, plugins_cls):
        try:
            pl = cl(config, sentry)
            pl.setup()
            plugins.append(pl)
        except Exception as e:
            cl_name = cl.__name__
            logging.error(f'Unable to load plugin {cl_name}: {e}')
    return plugins
