from typing import Dict, Set

CONFIGS = dict(
    prod=dict(
        run_cmd="/usr/local/bin/c3po-robot.py", config="/c3po_modules/configs/prod.ini"
    ),
    dev=dict(run_cmd="", config="/c3po_modules/configs/dev.ini"),
)
# NEW MAPPINGS

service_mapping = {
    "browser_everyday": {
        "golubtsov",
        "shibanov"
    },
    "coresec_everyday": {
        "styskin",
        "abovsky",
        "bunina",
        "agodin",
        "fomichev",
        "babenko",
        "chubinskiy",
        "milovidov",
        "bkht",
        "saint",
        "lyadzhin",
        "tsufiev",
        "dldmitry",
        "dshtan"
    },
    "sdc_everyday": {"dpolischuk"},
    "geo_everyday": {"baksheev"},
    "market_everyday": {
        "tumryaeva",
        "atarabrin",
        "evzvonkova",
        "mlevin",
        "abalakhnin",
        "a-pianov",
        "pavel-b",
        "knepom",
        "ashevenkov",
        "vlikh",
        "akostin",
        "geradmi",
        "daria-rezinko",
        "liumin",
        "fantamp",
        "tulupov"
    },
    "media_everyday": {"asavinovsky"},
    "taxi_everyday": {
        "anikin-am",
        "daniilsh"
    },
    "vertis_everyday": {"aleshin"},
    "zen_everyday": {"anton-fr"},
    "duty-ticket": {"abash"},  # That is cloud
    "bank_everyday": {"aidev"}
}

secreview_mapping = {
    # https://st-api.yandex-team.ru/v2/components/{magic_number_here}
    "57473": ["audap", "naumov-al", "azizalimov"],  # Taxi
    "57683": ["pavkir", "ezzer"],  # Verticals
    "57684": ["pavkir", "ezzer"],  # Zen
    "57685": ["ya-andrei", "ichalykin"],  # Market
    "57686": ["rshemyakin"],  # Mediaservices
    "57687": ["axlodin", "gpwn", "cheremushkin"],  # Cloud
    "57688": ["kaleda", "pavkir", "ezzer"],  # Experiments
    "57689": ["kaleda"],  # Other
    "57693": ["enr1g"],  # Geo
    "104195": ["dbeltukov", "mprokopovich"],  # Bank
    "105257": ["ilyaon"],  # FinOps
    "105258": ["ilyaon"],  # Pay
    "105259": ["a-abakumov"],  # 360
    "87555": ["a-abakumov"]  # Персональные сервисы
}  # coresec handled manually TODO

iss_tags_reverse_mapping = {
    "iss_browser": {"golubtsov", "shibanov"},
    "iss_vertis": {"aleshin"},
    "iss_sdc": {"dpolischuk"},
    "iss_media": {"asavinovsky"},
    "iss_taxi": {"anikin-am", "daniilsh"},
    "iss_eda": {"maresov"},
    "iss_lavka": {"dmasyuk"},
    "iss_edadeal": {"m-klimin"},
    "iss_drive": {"nikolaev87"},
    "iss_ydo": {"mborisov"},
    "iss_zapravki": {"aprudnikov", "rprudnikov"},
    "iss_travel": {"reyder"},
    "iss_cloud": {"abash"},
    "iss_market": {
        "tumryaeva",
        "atarabrin",
        "evzvonkova",
        "mlevin",
        "abalakhnin",
        "a-pianov",
        "pavel-b",
        "knepom",
        "ashevenkov",
        "vlikh",
        "akostin",
        "geradmi",
        "daria-rezinko",
        "liumin",
        "fantamp",
        "tulupov"
    },
    "iss_zen": {"ivanov"},
    "iss_praktikum": {"izalesskiy"},
    "iss_geo": {"baksheev"},
    "iss_search": {
        "ironpeter",
        "styskin",
        "abovsky",
        "bunina",
        "agodin",
        "fomichev",
        "babenko",
        "chubinskiy",
        "milovidov",
        "bkht",
        "saint",
        "lyadzhin",
        "tsufiev",
        "dshtan",
        "dldmitry",
    },
    "iss_hr": {"bunina"},
    "iss_finance": {"abovsky"},
    "iss_360": {"rusinov"},
    "iss_finops": {"dmitryno"},
    "iss_ecom": {"lyadzhin"},
    "iss_adv": {
        "veral",
        "sankear",
    },
    "iss_iot": {"shuster"},
    "iss_q": {"syudin"}
}


def reverse_mapping(mapping: Dict[str, Set]) -> Dict:
    d = dict()
    for key, values in mapping.items():
        for value in values:
            d.update({
                value: key
            })
    return d


iss_tags_mapping = reverse_mapping(iss_tags_reverse_mapping)

sectask_mapping = {
    "browser_everyday": {
        "golubtsov": [64073],
        "shibanov": [64073],
    },
    "coresec_everyday": {
        "styskin": [74524],
        "abovsky": [74525],
        "bunina": [74526],
        "agodin": [74524],
        "fomichev": [74524],
        "babenko": [74524],
        "chubinskiy": [74524],
        "milovidov": [74524],
        "bkht": [74524],
        "saint": [74524],
        "lyadzhin": [74524],
        "tsufiev": [74524],
        "dshtan": [74524],
        "dldmitry": [74524],
    },
    "sdc_everyday": {"dpolischuk": [88928]},
    "geo_everyday": {"baksheev": [64072]},
    "market_everyday": {
        "tumryaeva": [64075],
        "atarabrin": [64075],
        "evzvonkova": [64075],
        "mlevin": [64075],
        "abalakhnin": [64075],
        "a-pianov": [64075],
        "pavel-b": [64075],
        "knepom": [64075],
        "ashevenkov": [64075],
        "vlikh": [64075],
        "akostin": [64075],
        "geradmi": [64075],
        "daria-rezinko": [64075],
        "liumin": [64075],
        "fantamp": [64075],
        "tulupov": [64075],
    },
    "media_everyday": {"asavinovsky": [64071]},
    "taxi_everyday": {
        "anikin-am": [64076],
        "daniilsh": [64076]
    },
    "vertis_everyday": {"aleshin": [64069]},
    "zen_everyday": {"anton-fr": [64070]},
    "duty-ticket": {"abash": []},  # That is cloud
    "bank_everyday": {"aidev": [107844]},
}

service_reverse_mapping = {
    "a-abakumov": {"lyadzhin": 64058},
    "ilyaon": {"lyadzhin": 64058},
    "axlodin": {"abash": 51405},
    "kaleda": {
        "grishakov": 64055,
        "dpolischuk": 88935,
    },
    "ya-andrei": {"grishakov": 64055},
    "ichalykin": {"grishakov": 64055},
    "enr1g": {"baksheev": 64056},
    "audap": {"daniilsh": 64057},
    "naumov-al": {
        "daniilsh": 64057,
        "golubtsov": 31293,
        "shibanov": 31293,
    },
    "pavkir": {
        "aleshin": 64059,
        "anton-fr": 64060,
        "dpolischuk": 88935,
    },
    "ezzer": {
        "aleshin": 64059,
        "anton-fr": 64060,
        "dpolischuk": 88935,
    },
    "procenkoeg": {
        "agodin": 17661,
        "fomichev": 17661,
        "babenko": 17661,
        "chubinskiy": 17661,
        "milovidov": 17661,
        "bkht": 17661,
        "tsufiev": [74524],
    },
    "anton-k": {
        "dshtan": 17661,
        "agodin": 17661,
        "fomichev": 17661,
        "babenko": 17661,
        "chubinskiy": 17661,
        "milovidov": 17661,
        "bkht": 17661,
        "tsufiev": [74524],
    },
    "shikari": {
        "dshtan": 17661,
        "agodin": 17661,
        "fomichev": 17661,
        "babenko": 17661,
        "chubinskiy": 17661,
        "milovidov": 17661,
        "bkht": 17661,
        "tsufiev": [74524],
    },
    "ezaitov": {
        "dshtan": 17661,
        "agodin": 17661,
        "fomichev": 17661,
        "babenko": 17661,
        "chubinskiy": 17661,
        "milovidov": 17661,
        "bkht": 17661,
        "tsufiev": [74524],
    },
    "melkikh": {
        "dshtan": 17661,
        "agodin": 17661,
        "fomichev": 17661,
        "babenko": 17661,
        "chubinskiy": 17661,
        "milovidov": 17661,
        "bkht": 17661,
        "tsufiev": [74524],
    },
    "buglloc": {
        "dshtan": 17661,
        "agodin": 17661,
        "fomichev": 17661,
        "babenko": 17661,
        "chubinskiy": 17661,
        "milovidov": 17661,
        "bkht": 17661,
        "tsufiev": [74524],
    },
}

boss_followers_mapping = {
    'aleshin': ['svyatoslav', 'naumov-al', 'pavkir', 'ezzer'],
    'aandrosov': ['aandrosov'],
    'abulychev': ['abulychev'],
    'mi-a-grigorev': ['mi-a-grigorev'],
}

SIB_PEOPLE = (
    'sterh', 'katsello', 'khyurmeeva-e', 'ezaitov', 'andakimov', 'shikari', 'anton-k', 'buglloc', 'horus', 'melkikh',
    'procenkoeg', 'asuhanov', 'avasite', 'irmin', 'beeryukov', 'chrnkr', 'tdobro',
    'kkorotnev', 'dmitrykovalev', 'a-maksimova', 'mizerinas', 'tatis', 'ivishnitskiy', 'y-namestnikov', 'energen',
    'a-dzhamirze', 'withoutlogic', 'gots', 'kalyakinma', 'limetime', 'kaleda',
    'naumov-al', 'dselianin', 'enr1g', 'rshemyakin', 'spartacus', 'a-abakumov', 'dbeltukov', 'ilyaon', 'mprokopovich',
    'strawberry', 'alex-karpenko', 'relax-iamhere', 'dhmax', 'stagasov',
    'k-vaulin', 'dmrussak', 'vulerols', 'amebius', 'ichalykin', 'alferovri', 'max-rogov', 'ya-andrei', 'azizalimov',
    'audap', 'cheremushkin', 'axlodin', 'osipov-vadim', 'gpwn', 'pavkir', 'ezzer'
)  # TODO: sync yandex_mnt_security_0785


class ABC_ID:
    MARKET = 186
    SECURITY = 909
    ZEN = 1164
    YANDEX_360 = 847
    ACCESS_GRANTEE = 5982  # Подтверждающие доступ к данным
