import datetime
import time

from security.c3po.components.core.plugins import BasePlugin
from startrek_client import Startrek
from security.yaseclib.gap import Gap
from security.yaseclib.impulse import ImpulseQueuer
from security.yaseclib.tvm import TVM


# from security.yaseclib.appsec_discovery import AppsecDiscovery


class AppsecDuty(BasePlugin):
    title = u"Appsec Duty"
    desc = u"Плагин для заведение тикетов на разбор срабатываний ImPulse у выбранных БЮ"

    def setup(self):
        self.startrek = Startrek(
            useragent=self.config.get("st", "ua"),
            base_url=self.config.get("st", "url"),
            token=self.config.get("st", "token"),
        )
        self.tvm = TVM(
            client_id=self.config.get("tvm", "client_id"),
            client_secret=self.config.get("tvm", "client_secret"),
            destinations=self._config_getlist("tvm", "destinations"),
        )
        self.calendar_tvm_ticket = self.tvm.get_service_ticket(
            Gap.CALENDAR_YATEAM_TVM_ID
        )
        self.gap = Gap(
            base_url=self.config.get("gap", "url"),
            token=self.config.get("gap", "token"),
            base_calendar_url=self.config.get("calendar", "url"),
            calendar_tvm_service_ticket=self.calendar_tvm_ticket,
        )
        self.impulse = ImpulseQueuer(
            base_url=self.config.get("impulse", "url"),
            token=self.config.get("impulse", "token"),
        )

        self.services = self._config_getlist("plugins.appsec_duty", "services")

    def main(self):
        today = datetime.date.today()
        for service in self.services:
            # self.discovery = AppsecDiscovery(
            #                     token=self.config.get(
            #                                           service,
            #                                           'discovery_token'
            #                                         ),
            #                     api_url=self.config.get(
            #                                             'plugins.appsec_duty',
            #                                             'discovery_url')
            #                                         )
            self.create_daily_report(
                today=today,
                service=service,
            )
        self.tvm.stop()

    def create_daily_report(self, today, service):
        day_diff = 1
        if today.weekday() == 0:
            day_diff = 3

        start_date = today - datetime.timedelta(days=day_diff)
        week_number = today.isocalendar()[1]
        components = [self.config.getint(service, "component")]
        queue = self.config.get(service, "daily_queue")
        description = self.get_new_events(
            start_date=start_date, finish_date=today, service=service
        )
        summary = "%s Daily Process Audit %s | Week #%d" % (
            service.title(),
            today.isoformat(),
            week_number,
        )
        tags = [
            "%s_appsec_duty_daily" % service,
            "%s_appsec_duty_%d_%d" % (service, week_number, today.year),
        ]
        new_ticket = self.startrek.issues.create(
            queue=queue,
            summary=summary,
            type="task",
            tags=tags,
            description="**ImPulse**\n\n" + description,
            components=components,
        )
        if not description:
            time.sleep(5)
            new_ticket = self.startrek.issues[new_ticket.key]
            transition = new_ticket.transitions["close"]
            transition.execute(resolution="won'tFix")

    def get_new_events(self, start_date, finish_date, service):
        # final_text = '**Discovery**\n\n'
        # discovery_section = self.config.get(service, 'discovery_slugs')
        # for slug, event_types in self.config.items(discovery_section):
        #     event_types = self._config_getlist(discovery_section, slug)
        #     events = []
        #     for event_type in event_types:
        #         events.extend(
        #                     self.discovery.get_events(
        #                                             start_date=start_date,
        #                                             finish_date=finish_date,
        #                                             service=slug,
        #                                             event_type=event_type
        #                                           )
        #                     )
        #     if events:
        #         final_text += "**%s**\n\n" % slug
        #         for event in events:
        #             final_text += '((%s %s))\n' % (
        #                                            event['href'],
        #                                            event['description']
        #                                           )

        final_text = ""
        org_id = self.config.getint(service, "impulse_org_id")
        projects = self.impulse.get_org_projects(org_id)
        for project in projects:
            proj_id = int(project["id"])
            events = self.impulse.get_proj_vulns(org_id, proj_id)
            if events:
                for event in events:
                    final_text += (
                        "https://impulse.sec.yandex-team.ru/"
                        "organizations/"
                        "{organization_id}/"
                        "projects/{project_id}/"
                        "scans/{scan_type_name}/"
                        "instances/{scan_instance_id}/"
                        "vulnerabilities/"
                        "{id}\n".format(
                            organization_id=org_id,
                            project_id=proj_id,
                            scan_type_name=event["scan_type_name"],
                            scan_instance_id=event["scan_instance_id"],
                            id=event["id"],
                        )
                    )
        return final_text
