# -*- coding: utf-8 -*-
import time

from security.c3po.components.core.plugins import BasePlugin
from startrek_client import Startrek
from security.yaseclib.abc import Abc
from security.yaseclib.gap import Gap
from security.yaseclib.tvm import TVM


class AppsecDutyAssigner(BasePlugin):
    title = u"AppsecDutyAssigner"
    desc = u"Monitoring of forgotten issues in SECTASK/security"

    def setup(self):
        self.tvm = TVM(
            client_id=self.config.get("tvm", "client_id"),
            client_secret=self.config.get("tvm", "client_secret"),
            destinations=self._config_getlist("tvm", "destinations"),
        )
        self.calendar_tvm_ticket = self.tvm.get_service_ticket(
            Gap.CALENDAR_YATEAM_TVM_ID
        )

        self.gap = Gap(
            base_url=self.config.get("gap", "url"),
            token=self.config.get("gap", "token"),
            base_calendar_url=self.config.get("calendar", "url"),
            calendar_tvm_service_ticket=self.calendar_tvm_ticket,
        )
        self.startrek = Startrek(
            useragent=self.config.get("st", "ua"),
            base_url=self.config.get("st", "url"),
            token=self.config.get("st", "token"),
        )
        self.services = self._config_getlist("plugins.appsec_duty_assigner", "services")
        self.abc = Abc(
            base_url=self.config.get("abc", "url"),
            token=self.config.get("abc", "token"),
        )

    def main(self):
        time.sleep(10)
        for service in self.services:
            abc_slug = self.config.get(service, "duty_slug")
            daily_queue = self.config.get(service, "daily_queue")
            _ = self.config.get(service, "weekly_queue")  # TODO: Why not used?
            component = self.config.get(service, "component")

            self.assign_daily(daily_queue, abc_slug, service, component)
        self.tvm.stop()

    def assign_daily(self, queue, abc_slug, service, component):
        if self.gap.is_workday():
            st_query = (
                "Queue: %s "
                "Resolution: empty() "
                "Assignee: empty() "
                'Created:  <= today()+"1d" '
                "Tags:!processed "
                "Components: %s"
            )
            st_query = st_query % (queue, component)
            issues = self.startrek.issues.find(st_query)
            for issue in issues:
                assignee = self._choose_assignee(issue, abc_slug, service)
                if assignee:
                    issue.tags.append("processed")
                    issue.update(
                        assignee=assignee, tags=issue.tags, ignore_version_change=True
                    )

    def _choose_assignee(self, issue, abc_slug, service):
        assignee = self.config.get(service, "default_assignee")
        if abc_slug == "cloud_everyday":
            candidates = self.get_shifts_cloud()
            if candidates:
                assignee = self.get_shifts_cloud()[-1]
        else:
            shifts = self.abc.get_shifts(
                self.config.get("plugins.appsec_duty_assigner", "security_abc_id")
            )
            for shift in shifts:
                if shift:
                    shifts_slug = shift["schedule"]["slug"]
                    if shifts_slug == abc_slug:
                        assignee = shift["person"]["login"]
                        break
        return assignee

    def get_shifts_cloud(self):
        query = "Queue: CLOUDDUTY " "Components: 47232 " "Status:!closed "
        issues = self.startrek.issues.find(query)
        result = []

        for issue in issues:
            if issue.assignee:
                result = [issue.assignee.login]

        return result
