from security.c3po.components.core.plugins import BasePlugin
from startrek_client import Startrek


class CloudAlerts(BasePlugin):
    title = u"CloudAlerts"
    desc = u"Плагин для призыва дежурного Облака на тикеты, где исполнитель Злой Гусь"

    def setup(self):
        self.startrek = Startrek(
            useragent=self.config.get("st", "ua"),
            base_url=self.config.get("st", "url"),
            token=self.config.get("st", "token"),
        )

    def main(self):
        self._walk_st()

    def _walk_st(self):
        st_query = (
            '"Pending Reply From": robot-ycloud-secaler@ '
            "Queue: SECALERTS "
            "Resolution: empty() "
            "Components: 51425"
        )

        issues = self.startrek.issues.find(st_query)
        for issue in issues:
            self.summon_on_duty(issue)

    def summon_on_duty(self, issue):
        summonee, duty_issue = self.get_shifts_cloud(return_issue_key=True)
        issue.links.create(issue=duty_issue.key, relationship="relates")
        issue = self.startrek.issues[issue.key]
        self._summon(issue, summonee)

    def _summon(self, issue, summonee, template=""):
        # t = self.env.get_template(template)
        issue.comments.create(
            # text=t.render(),
            text="",
            summonees=summonee,
        )
        return True

    def get_shifts_cloud(self):
        query = (
            "Queue: CLOUDDUTY "
            "Components: 47232 "
            "Status:!closed "
            '"Sort By": Created ASC'
        )
        issues = self.startrek.issues.find(query)
        assignee = ""

        for issue in issues:
            if issue.assignee:
                assignee = issue.assignee.login
                issue_key = issue.key

        return assignee, issue_key
