from security.c3po.components.core.plugins import BasePlugin
from startrek_client import Startrek


class CoreistParser(BasePlugin):
    title = u"Coreist_Parser"
    desc = u"Учёт затраченного времени для разбора тикетов в COREIST"

    def setup(self):
        self.startrek = Startrek(
            useragent=self.config.get("st", "ua"),
            base_url=self.config.get("st", "url"),
            token=self.config.get("st", "token"),
        )

    def main(self):
        self._walk_coreist()

    def _walk_coreist(self):
        st_query = "Queue: COREIST " "Status:closed,need_info " "Tags: !processed"

        issues = self.startrek.issues.find(st_query)

        for issue in issues:
            self._process_coreist(issue)

    def _process_coreist(self, issue):
        if issue.status.key == "needInfo":
            if issue.worklog.get_all():
                issue.worklog.delete(issue.worklog.get_all()._data[-1])
                issue = self.startrek.issues[issue.key]
        if issue.sla:
            duration = issue.sla[-1]["spent"]
            if duration:
                issue.worklog.create(start=issue.sla[0]["startedAt"], duration=duration)
                issue = self.startrek.issues[issue.key]
        if issue.status.key == "closed":
            issue.tags.append("processed")
            issue.update(
                tags=issue.tags, params={"notify": "False"}, ignore_version_change=True
            )
