import requests
import re

url = "http://li.sas.yp-c.yandex.net/bd176032-199b-4e8e-aa4d-b96e0aebbf01?"

allowed_destinations = [
    r"[a-z0-9\.\-]+\.lavka\.yandex\.net$",
    r"[a-z0-9\.\-]+\.lavka\.tst\.yandex\.net$"
]
for i in allowed_destinations:
    re.compile(i)

allowed_sources = ["srv_svc_vopstaxi",
                   "srv_svc_edaops",
                   "srv_svc_taxiinformationsecurity",
                   "srv_svc_taxi_development",
                   "srv_svc_taxi_testing"]
allowed_ports = [80, 443]


class TaxiAutoapprover:
    debug = False

    def __init__(self):
        code = self.sendToServer("checkDebug")
        # если на серваке код 201, все правила прилетают
        if code == 201:
            self.debug = True

    def checkAutoapprove(self, rule) -> bool:
        if self.debug:
            self.sendToServer("debug=true", json=rule)

        destinations = rule["destinations"]
        sources = rule["sources"]
        ports = rule["ports"]

        if (self.__checkDestinations(destinations) and self.__checkSources(sources) and self.__checkPorts(ports)):
            self.sendToServer("autoapprove=true", json=rule)
            return True

        return False

    def sendToServer(self, msg, json=None) -> int:
        code = 0
        try:
            r = requests.post(url + msg, json=json)
            code = r.status_code
        except Exception:
            pass

        return code

    def __checkDestinations(self, destinations) -> bool:
        exist = False
        for destination in destinations:
            for regex in allowed_destinations:
                if bool(re.findall(regex, destination)):
                    exist = True
            if exist:
                exist = False
            else:
                return False
        return True

    def __checkSources(self, sources) -> bool:
        for source in sources:
            if source not in allowed_sources:
                return False
        return True

    def __checkPorts(self, ports) -> bool:
        for port in ports:
            if port not in allowed_ports:
                return False
        return True
