# -*- coding: utf-8 -*-
import datetime
import logging

from security.c3po.components.core.plugins import BasePlugin
from startrek_client import Startrek


class SecauditAutoapprover(BasePlugin):
    title = u"SECAUDIT APPROVER"
    desc = (
        u"Аппрув аудитов лендингов форм. "
        u'Если через 20 часов аудит не выполнен, тикет переводится в статус "Утверждён"'
    )
    resolved_statuses = ["closed"]
    autoroll_text = (
        "Тикет на аудит лендинга обрабатывается больше 20 часов,"
        'перевожу тикет в статус "Утвержден".'
    )

    def setup(self):
        self.startrek = Startrek(
            useragent=self.config.get("st", "ua"),
            base_url=self.config.get("st", "url"),
            token=self.config.get("st", "token"),
        )

    def main(self):
        for issue in self.get_landing_audits():
            created = datetime.datetime.strptime(
                issue["createdAt"], "%Y-%m-%dT%H:%M:%S.%f+0000"
            )

            if created + datetime.timedelta(
                hours=24
            ) > datetime.datetime.now() or datetime.datetime.now().weekday() in [5, 6]:
                # we're not interested in tickets newer than 20hrs
                continue

            unresolved = list(filter(self.is_unresolved_issue, issue.links))
            if not unresolved:
                logging.info("Autoapprove ticket {}".format(issue.key))
                # FIXME
                issue = self.startrek.issues[issue.key]
                issue.tags.append("auto_approved")
                issue.update(tags=issue.tags, ignore_version_change=True)
                # FIXME
                issue = self.startrek.issues[issue.key]
                try:
                    transition = issue.transitions["approved"]
                    transition.execute(
                        comment=self.autoroll_text,
                    )
                except Exception:
                    with self.sentry_module.push_scope():
                        self.sentry_module.capture_exception()
                    logging.info("Autoapprove ticket {} error".format(issue.key))

    def get_landing_audits(self):
        st_query = (
            "Queue: SECAUDIT "
            + "Resolution: empty() "
            + "Tags: autoroll "
            + "Tags: !auto_approved "
        )
        issues = self.startrek.issues.find(st_query)
        return issues

    def is_unresolved_issue(self, issue):
        if issue.status.key in self.resolved_statuses:
            return False
        if not issue.object.security:
            # Ignore all tickets except security
            return False
        return True
