# -*- coding: utf-8 -*-
import logging

from startrek_client import Startrek

from security.c3po.components.core.plugins import BasePlugin


class SecauditCloser(BasePlugin):
    title = u"SECAUDIT CLOSER"
    desc = u'Закрытие тикета на аудит в состоянии "Решён" при условии закрытия связанных тикетов с Security: Yes'

    resolved_statuses = ["closed"]
    autoclose_text = (
        u"Всем спасибо!" + u" Связанные задачи решены, задачу на аудит закрываю."
    )

    def setup(self):
        self.startrek = Startrek(
            useragent=self.config.get("st", "ua"),
            base_url=self.config.get("st", "url"),
            token=self.config.get("st", "token"),
        )

    def main(self):
        for issue in self.get_solved_audits():
            unresolved = list(filter(self.is_unresolved_issue, issue.links))
            if not unresolved:
                # All issues are resolved, let's close SECAUDIT
                logging.info("Autoclose ticket {}".format(issue.key))
                # FIXME
                issue = self.startrek.issues[issue.key]
                issue.tags.append("auto_closed")
                issue.update(tags=issue.tags, ignore_version_change=True)
                # FIXME
                issue = self.startrek.issues[issue.key]
                transition = issue.transitions["close"]
                transition.execute(comment=self.autoclose_text, resolution="fixed")

    def get_solved_audits(self):
        st_query = """Queue: "SECAUDIT" Status: "Решен" Tags:!auto_closed"""
        issues = self.startrek.issues.find(st_query)
        return issues

    def is_unresolved_issue(self, issue):
        if issue.status.key in self.resolved_statuses:
            return False
        if not issue.object.security:
            # Ignore all tickets except security
            return False
        return True
