# -*- coding: utf-8 -*-
import datetime

from startrek_client import Startrek

from security.c3po.components.core.plugins import BasePlugin


class SecauditReminder(BasePlugin):
    title = u"SECAUDIT REMINDER"
    desc = u"Напоминаем исполнителям о приближении дедлайна аудита"

    sib_notification_text = (
        "До планируемого запуска осталось менее 7 дней, "
        "пожалуйста, выделите время на этот тикет."
    )

    srv_notification_text = (
        "До планируемого запуска осталось менее 7 дней, "
        "для продолжения аудита необходима "
        "информация от комадны сервиса."
    )

    sib_fail_text = (
        "Пропущены сроки запуска — пожалуйста, " "выделите время на этот тикет ASAP."
    )

    def setup(self):
        self.startrek = Startrek(
            useragent=self.config.get("st", "ua"),
            base_url=self.config.get("st", "url"),
            token=self.config.get("st", "token"),
        )

    def main(self):
        for issue in self.get_abandoned_audits():
            if issue.deadline:
                deadline_datetime = datetime.datetime.strptime(
                    issue.deadline, "%Y-%m-%d"
                )
                # launches mostly happen during working hours
                deadline_datetime += datetime.timedelta(hours=8)
                delta = deadline_datetime - datetime.datetime.now()
                # 7 is magic number ;)
                if delta.days > 7:
                    continue
                # skip for landing pages
                if "autoroll" in issue.tags:
                    continue
                issue.tags.append("late")
                issue.update(tags=issue.tags, ignore_version_change=True)
                issue = self.startrek.issues[issue.key]
                if issue.status.key in ["needInfo"]:
                    issue.comments.create(
                        text=self.srv_notification_text, summonees=issue.createdBy.login
                    )
                else:
                    if not hasattr(issue.assignee, "login") or not issue.assignee:
                        return
                    if deadline_datetime < datetime.datetime.now():
                        # we already missed deadlines
                        issue.comments.create(
                            text=self.sib_fail_text, summonees=issue.assignee.login
                        )
                    else:
                        issue.comments.create(
                            text=self.sib_notification_text,
                            summonees=issue.assignee.login,
                        )

    def get_abandoned_audits(self):
        st_query = (
            u"Queue: SECAUDIT "
            + u"Resolution: empty() "
            + u'Status:!"Решен" '
            + u'Status:!"Утвержден" '
            + u"Tags:!late "
        )
        issues = self.startrek.issues.find(st_query)
        return issues
