# -*- coding: utf-8 -*-
import logging

from security.c3po.components.core.plugins import BasePlugin
from jinja2 import Environment, FileSystemLoader
from startrek_client import Startrek
from security.yaseclib.abc import Abc


class Secduty(BasePlugin):
    title = u"Secduty"
    desc = u"Creator of duty tickets"

    def setup(self):
        self.startrek = Startrek(
            useragent=self.config.get("st", "ua"),
            base_url=self.config.get("st", "url"),
            token=self.config.get("st", "token"),
        )
        self.abc = Abc(
            base_url=self.config.get("abc", "url"),
            token=self.config.get("abc", "token"),
        )
        self.env = Environment(
            loader=FileSystemLoader(
                self.resource_path() / "issue_templates"
            )
        )

    def main(self):
        duty_data = self.abc.get_shifts(909)
        for shift in duty_data:
            assignee = shift["person"]["login"]
            slug = shift["schedule"]["slug"]
            query = (
                "Queue:SECDUTY "
                "Status:!closed "
                "Assignee:%s "
                "Tags:%s "
                "Deadline:%s"
                % (assignee, shift["schedule"]["slug"], shift["end_datetime"][:10])
            )
            issues = self.startrek.issues.find(query)
            if not issues:
                try:
                    self.create_issue(shift)
                except Exception as e:
                    logging.error(
                        f"Unable to create issue for {assignee}: {str(e)}. Did you have propper template for `{slug}` slug?"
                    )
        close_query = "Queue:SECDUTY " "Status:!closed " "Deadline:<today()"
        issues = self.startrek.issues.find(close_query)
        for issue in issues:
            self.close_issue(issue)

    def create_issue(self, shift):
        summary = "%s | %s — %s" % (
            shift["schedule"]["name"],
            shift["start"],
            shift["end_datetime"][:10],
        )
        t = self.env.get_template(shift["schedule"]["slug"])
        description = t.render()
        self.startrek.issues.create(
            queue="SECDUTY",
            summary=summary,
            type="task",
            tags=[shift["schedule"]["slug"]],
            deadline=shift["end_datetime"][:10],
            description=description,
            assignee=shift["person"]["login"],
        )

    def close_issue(self, issue):
        issue = self.startrek.issues[issue.key]
        transition = issue.transitions["close"]
        transition.execute(resolution="fixed")
