# -*- coding: utf-8 -*-
import re
import requests

from security.c3po.components.core.plugins import BasePlugin
from startrek_client import Startrek


class WebauthAlerts(BasePlugin):
    title = u"webauth_alerts"
    desc = u"Monitoring of issues in SECALERTS/webauth"
    ERE = re.compile(r"\*\*environmentId\*\*\s\|\s\%\%(.*?)\%\%\s\|\|")

    comment_text = u"Пожалуйста, скажите, почему вы отключили webauth."
    event_deleted_text = u"Окружение удалено или webauth на месте."

    def setup(self):
        self.startrek = Startrek(
            useragent=self.config.get("st", "ua"),
            base_url=self.config.get("st", "url"),
            token=self.config.get("st", "token"),
        )

    def main(self):
        for issue in self.get_unchecked_issues():
            if "webauth" not in issue.summary:
                continue
            envid = self.ERE.findall(issue.description)[0]
            env_data = self.get_qloud_env(envid)
            if env_data:
                self._set_checked(issue)
                self._add_comment(issue)
                issue.update(assignee=env_data.get("author"))
            else:
                self.close_issue(issue.key, self.event_deleted_text)

    def get_unchecked_issues(self):
        st_query = (
            "Queue: SECALERTS "
            "AND Resolution: empty() "
            "AND Assignee: ezaitov "
            "AND Tags:! auto_processed"
        )
        issues = self.startrek.issues.find(st_query)
        return issues

    def _set_checked(self, issue, errors=[]):
        tags = [u"auto_processed"]
        # FIXME
        issue = self.startrek.issues[issue.key]
        issue.update(tags=issue.tags + tags, ignore_version_change=True)

    def get_qloud_env(self, envid):
        try:
            base_url = (self.config.get("qloud", "url"),)
            token = self.config.get("qloud", "token")
            r = requests.get(
                "{}/api/v1/environment/stable/{}".format(base_url, envid),
                headers={"Authorization": "OAuth {}".format(token)},
            )
            env_data = r.json()
        except Exception:
            return None
        else:
            return env_data

    def _add_comment(self, issue, comment):
        return issue.update(comment=comment, ignore_version_change=True)

    def close_issue(self, ticket_id, comment):
        issue = self.startrek.issues[ticket_id]
        for t in issue.transitions.get_all():
            if t.id == "closed":
                transition = issue.transitions["closed"]
                transition.execute(comment=comment)
                break
