# -*- coding: utf-8 -*-

from datetime import date

from security.c3po.components.core.plugins import BasePlugin
from security.yaseclib.staff import Staff
from security.yaseclib.sender import Sender
from security.yaseclib.statmaster import StatSender


class Welcome(BasePlugin):
    title = u"Welcome letter to developers sender"
    desc = u"Старый плагин для отправки писем новым сотрудникам по подразделениям через https://sender.yandex-team.ru/"

    def setup(self):
        self.staff = Staff(
            base_url=self.config.get("staff", "url"),
            token=self.config.get("staff", "token"),
        )
        self.sender = Sender(
            base_url=self.config.get("sender", "url"),
            token=self.config.get("sender", "token"),
            account_slug=self.config.get("sender", "account_slug"),
        )
        self.stat_sender = StatSender(
            self.config.get("stat", "robot_login"),
            self.config.get("stat", "robot_password"),
            self.config.get("stat", "url"),
        )

        self.campaign_slug = self.config.get("plugins.welcome", "sender_campaign_slug")
        self.bro_campaign_slug = self.config.get(
            "plugins.welcome", "bro_sender_campaign_slug"
        )
        self.taxi_campaign_slug = self.config.get(
            "plugins.welcome", "taxisec_sender_campaign_slug"
        )
        self.stat_report_url = self.config.get("plugins.welcome", "stat_report_url")

    def main(self):
        today_iso = date.today().isoformat()

        all_devs = self.staff.get_persons("Разработка", today_iso)
        bro_devs = self.staff.get_persons_by_depart_url(
            "yandex_distproducts_browserdev_desktopdev", today_iso
        )

        taxi_devs = []
        departments = [
            # Main Taxi Dev
            "yandex_distproducts_browserdev_mobile_taxi",
            # Platform Effectivity Dev
            "yandex_rkub_taxi_marketing_6154_dep79096",
            # Taxi Partner product development sector
            "yandex_distproducts_browserdev_mobile_taxi_client",
            # Taxi client product server development department
            "yandex_distproducts_morda_commercial_prod_dep63345_dep18467",
            # Taxi client product mobile development department
            "yandex_distproducts_morda_commercial_prod_dep63345_dep92426",
            # Taxi Group of geo-product development
            "yandex_distproducts_morda_commercial_prod_dep75777",
            # Transport's product group
            "yandex_distproducts_morda_commercial_prod_dep72936",
            # Yandex.Taxi analytics department
            "yandex_mrkt_analytics_serv_taxi",
            # Yandex.Eda Development Department
            "yandex_rkub_taxi_5151_8501_9282",
            # Yandex.Grocery development department
            "yandex_rkub_taxi_5151_8501_dep41202_dep48321",
            # Yandex.Taxi new bussiness development department
            "yandex_rkub_taxi_dep80006_dep47288",
            # Yandex.Taxi partner department
            "yandex_distproducts_morda_commercial_prod_9088",
            # Yandex.Taxi geoproduct department
            "yandex_distproducts_morda_commercial_prod_dep75777",
        ]

        for department in departments:
            taxi_devs.extend(
                self.staff.get_persons_by_depart_url(department, today_iso)
            )

        if all_devs and bro_devs:
            all_devs = [dev for dev in all_devs if dev not in bro_devs]
        if all_devs and taxi_devs:
            all_devs = [dev for dev in all_devs if dev not in taxi_devs]

        self._send_welcome(all_devs, self.campaign_slug)
        self._send_welcome(bro_devs, self.bro_campaign_slug)
        self._send_welcome(taxi_devs, self.taxi_campaign_slug)
        stat_data = {
            "other_devs": len(all_devs),
            "bro_devs": len(bro_devs),
            "taxi_devs": len(taxi_devs),
        }
        self.stat_sender.post_to_stat(name=self.stat_report_url, data=stat_data)

    def _send_welcome(self, recievers, campaign_slug):
        for person in recievers:
            to_email = person["login"] + "@yandex-team.ru"
            args = {"name": person["name"]["first"]["ru"]}
            self.sender.send(campaign_slug, to_email, args)
