import datetime

from jinja2 import Environment, FileSystemLoader
from security.c3po.components.core.plugins import BasePlugin
from startrek_client import Startrek
from security.yaseclib.abc import Abc


class YcloudDockerRedeploy(BasePlugin):
    title = u"YcloudDockerRedeploy"
    desc = (
        u"Регулярный передеплой систем Облака для обновления зависимостей "
        u"https://wiki.yandex-team.ru/datalens/regulations/regularredeploy/"
    )

    def setup(self):
        self.abc = Abc(
            base_url=self.config.get("abc", "url"),
            token=self.config.get("abc", "token"),
        )

        self.startrek = Startrek(
            useragent=self.config.get("st", "ua"),
            base_url=self.config.get("st", "url"),
            token=self.config.get("st", "token"),
        )

        self.env = Environment(
            loader=FileSystemLoader(
                self.resource_path() / "templates"
            )
        )

        self.services = self._config_getlist(
            "plugins.ycloud_docker_redeploy", "services"
        )

    def main(self):
        today = datetime.date.today()
        for service in self.services:
            self.create_update_ticket(
                today=today,
                service=service,
            )

    def create_update_ticket(self, today, service):
        summary = "%s Container Update Process %s | Month #%d" % (
            service.title(),
            today.isoformat(),
            today.month,
        )

        abc_id = self.abc.get_service_by_slug(service)["id"]
        assignee = self.abc.get_service_head_by_id(abc_id)

        queue = self.config.get("plugins.ycloud_docker_redeploy", "queue")
        components = self._config_getlist(
            "plugins.ycloud_docker_redeploy", "components"
        )
        components = [int(component) for component in components]

        tags = [
            "%s_container_update" % service,
            "cloud_sec_improvement",
            "cloud_compliance",
            "security_updates",
            "prod",
        ]

        template = "simple_summon.tpl"
        text = self.env.get_template(template)
        description = text.render(service_slug=service, responsible=assignee)
        self.startrek.issues.create(
            type="task",
            queue=queue,
            summary=summary,
            description=description,
            assignee=assignee,
            tags=tags,
            components=components,
            security="Yes",
            followers=["kaleda"],
        )
