#!/bin/bash

export LANG=en_US.UTF-8

scripts_path=/c3po/scripts
configs_path=${1:-/c3po/configs}
logs_path=/c3po/logs

$scripts_path/generic_config.sh $configs_path $logs_path

$scripts_path/config_6min.sh $configs_path $logs_path
$scripts_path/config_30min.sh $configs_path $logs_path
 
$scripts_path/config_noon.sh $configs_path $logs_path
$scripts_path/config_midnight.sh $configs_path $logs_path
 
$scripts_path/config_ycloud.sh $configs_path $logs_path
$scripts_path/config_ticket_reporter_ini.sh $configs_path $logs_path
$scripts_path/config_ticket_escalator_ini.sh $configs_path $logs_path

CMD="/usr/bin/supervisord --nodaemon --configuration=/etc/supervisor/supervisord.conf"
YT_LOCK_PROXY=LOCKE
YT_LOCK_PREFIX=//home/security/c3po/prod/lock
while true
do
    YT_TOKEN=$yt_token /bin/yt_lock "$YT_LOCK_PREFIX/lock", "$CMD" --proxy=$YT_LOCK_PROXY --create-lock
    sleep 10
done
