**Напоминаем, что необходимо обновить образы Docker-контейнеров, которые используются в ваших сервисах**. 

1. Обновите внешние Docker-образы (те, которые собираются не вами, но используются в ваших сервисах) на новые версии. К доверенным относятся образы, поставляемые Canonical и Google.
2. Обновите версии базовых образов (указанных в секции %%FROM%% в Dockerfile)
3. Если в вашем образе устанавливаются пакеты конкретных версий - обновите эти версии.
4. Если в вашем образе есть пакеты без версии (например, %%FROM ubuntu%%), в них нужно добавить команду %%apt-get update -qq && apt-get dist-upgrade -y%% и пересобрать. Для образов, в которых только добавляются бинарники кода такое не применимо. При этом, если вы используете %%docker build%% для сборки образов, то не забудьте указать опцию %%--no-cache%%, которая отключает кэширование. В качестве альтернативы вы можете ((https://docs.docker.com/develop/develop-images/dockerfile_best-practices/#run явно указать версии пакетов)), которые вы хотите установить. <{ Подробности
Если вы не укажете опцию %%--no-cache%%, то при сборке образа Docker ((https://docs.docker.com/develop/develop-images/dockerfile_best-practices/#leverage-build-cache будет использовать)) слой, находящийся в кэше, и не обновит пакеты.
К примеру, если вы сделаете %%docker build%% без опции %%--no-cache%% для //Dockerfile//, содержащего следующую строку, то пакеты не обновятся: 
%%(bash)
RUN apt-get update && \
    apt-get upgrade -y && \
    apt-get install -y python3
%%

При этом следующая команда гарантирует установку //нужных версий// пакетов: 
%%(bash)
RUN apt-get update && apt-get install -y \
    ruby1.9.1 \
    ruby1.9.1-dev \
%%
}>

__Информация о сервисе__:
* Сервис: https://abc.yandex-team.ru/services/{{service_slug}}
* Ответственный: кто:{{responsible}}

После пересборки новые версии образов необходимо задеплоить.

----

//Если вы не знаете, что делать, призовите кого-нибудь из https://abc.yandex-team.ru/services/ycsecurity/ в этот тикет или обратитесь к дежурному по security.//