param( [string]$a = "a")

#-----------JSON config

$emailConfig = Get-Content -Path C:\CxEmailConfig\Cx_reporter_settings.json 
$emailConfigJSON = $emailConfig | ConvertFrom-Json 

#----------------------

$param = @{
 SmtpServer = $emailConfigJSON.GlobalSettings.SMTPSettings.Host
 Port = $emailConfigJSON.GlobalSettings.SMTPSettings.Port
 From = $emailConfigJSON.GlobalSettings.SMTPSettings.Sender
 Subject = 'Scan results from Checkmarx'
 Body = "Please find scan results attached."
 #Attachments = $a
}

foreach($setting in $emailConfigJSON.ProjectSettings){

    if($a -match $setting.Project)
    {
        
        $param.Subject = 'CxSAST: Scan for project ' + $setting.Project + ' is ready'
        $param.Body = [string]::Join("<br>" ,
                        "Checkmarx has scanned your repository: "+ $setting.Comment,
                        "You can find the scan results attached.",
                        "These results will be reviewed by Security Team, so",
                        "&nbsp;<b>no actions required</b> from your side.",
                        "It's <b>just a gentle reminder</b> that your code is being scanned for security issues on a regular basis.",
                        "Security Team will get in touch if any real security issues found in your code, but you can also review the results yourself using the links below.",
                        "Checkmarx console: https://checkmarx.yandex.net/CxWebConsole",
                        "Manual and additional tips: https://nda.ya.ru/3VnMi2" ,
                        "",
                        "Best regards",
                        "Security Team & robot-checkmarx"
                        )
        $param.To = @($setting.Email.To)
    
        break;
    }
}

if ($param.To -is [system.array] -and $param.To.Count -gt 0) {
    Send-MailMessage @param -BodyAsHtml
}
