resource "random_password" "owner_password" {
  length  = 20
  special = false

}

resource "random_password" "soc_reader_password" {
  length  = 20
  special = false
}

resource "yandex_mdb_postgresql_cluster" "cloudquery_pg" {
  name                = var.pg_cluster_name
  environment         = "PRODUCTION"
  description         = "Example PG database to store results of cloudquery tool"
  network_id          = ""
  deletion_protection = true

  config {
    version = 14

    backup_retain_period_days = 7

    resources {
      resource_preset_id = "s3.nano"
      disk_type_id       = "local-ssd"
      disk_size          = "30"
    }

    pooler_config {
      pooling_mode = "SESSION"
    }

    postgresql_config = {
      shared_preload_libraries = "SHARED_PRELOAD_LIBRARIES_TIMESCALEDB"
    }
  }

  database {
    name  = var.pg_db_name
    owner = var.pg_db_cloudquery_user
    # extension {
    #   name = "timescaledb"
    # }
  }

  user {
    name     = var.pg_db_cloudquery_user
    password = random_password.owner_password.result
    permission {
      database_name = var.pg_db_name
    }
  }

  user {
    name     = var.pg_db_soc_reader
    password = random_password.soc_reader_password.result
    permission {
      database_name = var.pg_db_name
    }
    grants = [var.pg_db_name]
  }

  host {
    zone = "vla"
  }
}

output "hostname" {
  value = flatten(yandex_mdb_postgresql_cluster.cloudquery_pg.host.*.fqdn)
}

output "cloudquery_password" {
  value     = random_password.owner_password
  sensitive = true
}

output "soc_reader_password" {
  value     = random_password.soc_reader_password
  sensitive = true
}
