resource "random_password" "owner_password" {
  length  = 20
  special = false

}

resource "random_password" "soc_reader_password" {
  length  = 20
  special = false
}

resource "yandex_mdb_postgresql_cluster" "cloudquery_pg" {
  name                = var.pg_cluster_name
  environment         = "PRODUCTION"
  description         = "Production cluster for Cloudquery"
  network_id          = ""
  deletion_protection = true

  config {
    version = 14

    backup_retain_period_days = 7

    resources {
      resource_preset_id = "s2.micro"
      disk_type_id       = "local-ssd"
      disk_size          = "30"
    }

    pooler_config {
      pooling_mode = "SESSION"
    }

    # postgresql_config = {
    #   shared_preload_libraries = "SHARED_PRELOAD_LIBRARIES_TIMESCALEDB"
    # }
  }

  dynamic "database" {
    for_each = toset(var.databases)
    content {
      name  = database.value
      owner = var.pg_db_cloudquery_user
      # extension {
      #   name = "timescaledb"
      # }
    }
  }

  user {
    name       = var.pg_db_cloudquery_user
    password   = random_password.owner_password.result
    conn_limit = 200
    dynamic "permission" {
      for_each = toset(var.databases)
      content {
        database_name = permission.value
      }
    }
  }

  user {
    name       = var.pg_db_soc_user
    password   = random_password.soc_reader_password.result
    conn_limit = 50
    dynamic "permission" {
      for_each = toset(var.databases)
      content {
        database_name = permission.value
      }
    }
    # Do not forget about:
    # GRANT SELECT ON ALL tables in schema cloudquery TO soc;
    # GRANT USAGE ON SCHEMA cloudquery to soc ;
  }

  dynamic "host" {
    for_each = var.host_zones
    content {
      name = "host-${host.key}-${host.value}"
      zone = host.value
    }
  }
}
