cloudquery {
  provider "yandex-cloud/yandex" {
    source  = ""
    version = "v0.0.8"
  }
  connection {
    dsn = "postgresql://cloudquery:${POSTGRES_PASSWORD}@${POSTGRES_HOST}:6432/yabank?ssl=true"
  }
}

provider "yandex" {
  configuration {
    cloud_ids = [
      "b1gprqvt338vca2j62hh", // yabank-main_cloud
      "b1gofkeli7vvq22ji5so", // yabank-npe_cloud
    ]
  }

  env = [
    "YC_SERVICE_ACCOUNT_KEY_FILE=${YC_SERVICE_ACCOUNT_KEY_FILE}"
  ]

  resources = [
    "AccessBindingsByCloud",
    "AccessBindingsByFolder",
    "AccessBindingsByOrganization",
  ]
  enable_partial_fetch = true
}
