#!/usr/bin/env python

import requests
import settings
import syslog
import molly_runner
import tenacity


@tenacity.retry(retry=tenacity.retry_if_exception_type(requests.exceptions.ConnectionError))
def force_scan():
    if molly_runner.Crasher.get_scan_status() == molly_runner.Crasher.SCAN_STATUS_IDLE:
        requests.put(settings.MOLLY_PREFIX + '/crasher/',
                     data={'status': 2},
                     headers={'Authorization': settings.AUTH_TOKEN})


if __name__ == '__main__':
    syslog.openlog("Crasher")
    force_scan()
    syslog.syslog("Forced Scan")
