#!/usr/bin/env python

import requests
import settings
import syslog
import molly_runner


def force_stop():
    try:
        crasher = molly_runner.Crasher()
        chunks_uid = crasher.get_chunks_uid()
        print(chunks_uid)
        for uid in chunks_uid:
            requests.delete(settings.MOLLY_PREFIX + '/crasher-state/' + uid + '/',
                            headers={'Authorization': settings.AUTH_TOKEN})
    except TypeError:
        pass
    requests.put(settings.MOLLY_PREFIX + '/crasher/',
                 data={'status': 0},
                 headers={'Authorization': settings.AUTH_TOKEN})


if __name__ == '__main__':
    syslog.openlog("Crasher")
    force_stop()
    syslog.syslog("Forced Stop")
