#!/usr/bin/env python

import requests
import subprocess
import settings
import syslog
import tenacity

@tenacity.retry()
def is_scan_forced():
    res = requests.get(settings.MOLLY_PREFIX + '/crasher/',
                       headers={'Authorization': settings.AUTH_TOKEN})
    t = res.json()
    return t.get('status', 0) == 2


if __name__ == '__main__':
    syslog.openlog("Crasher")
    syslog.syslog("Heartbeat")
    if is_scan_forced():
        subprocess.call(settings.CRASHER_CMD)
