package integration

import (
	"context"
	"io/ioutil"
	"net"
	"strconv"
	"strings"
	"testing"
	"time"

	"github.com/stretchr/testify/require"
	"go.uber.org/zap/zaptest"

	"a.yandex-team.ru/library/go/core/log"
	"a.yandex-team.ru/library/go/core/log/zap"
)

type LbEnv struct {
	Endpoint string
	Port     int
	Topic    string
	Consumer string
	logger   log.Logger

	t   testing.TB
	ctx context.Context
}

func NewLbEnv(t testing.TB) (e *LbEnv, stop func()) {
	rawPort, err := ioutil.ReadFile("ydb_endpoint.txt")
	require.NoError(t, err)

	port, err := strconv.Atoi(strings.TrimSpace(string(rawPort)))
	require.NoError(t, err)

	e = &LbEnv{
		Endpoint: "localhost",
		Port:     port,
		Topic:    "default-topic",
		Consumer: "test_client",
		logger:   &zap.Logger{L: zaptest.NewLogger(t)},
		t:        t,
	}

	var cancelCtx func()
	e.ctx, cancelCtx = context.WithTimeout(context.Background(), time.Minute)

	stop = cancelCtx
	return
}

func GetFreeAddr() (string, error) {
	addr, err := net.ResolveTCPAddr("tcp", "127.0.0.1:0")
	if err != nil {
		return "", err
	}

	l, err := net.ListenTCP("tcp", addr)
	if err != nil {
		return "", err
	}
	defer func() { _ = l.Close() }()

	return l.Addr().(*net.TCPAddr).String(), nil
}
