package app

import (
	"fmt"

	"a.yandex-team.ru/library/go/core/log"
	"a.yandex-team.ru/library/go/yandex/tvm/tvmtool"
)

type Option func(app *App) error

func WithLogger(l log.Structured) Option {
	return func(app *App) error {
		app.logger = l
		return nil
	}
}

func WithAddr(addr string) Option {
	return func(app *App) error {
		app.https.Addr = addr
		return nil
	}
}

func WithTvm() Option {
	return func(app *App) error {
		// TODO(buglloc): peace of shit, logger may be not initialized so far
		tvmClient, err := tvmtool.NewDeployClient(
			tvmtool.WithBackgroundUpdate(app.ctx),
			tvmtool.WithLogger(app.logger),
		)

		if err != nil {
			return fmt.Errorf("failed to create tvmclient: %w", err)
		}

		app.tvm = tvmClient
		return nil
	}
}
