package diskqueue

import "a.yandex-team.ru/library/go/core/log"

type Option func(queue *DiskQueue)

func WithMaxMsgSize(size int) Option {
	return func(queue *DiskQueue) {
		queue.maxMsgSize = uint32(size)
	}
}

func WithMaxBytesPerFile(size int) Option {
	return func(queue *DiskQueue) {
		queue.maxBytesPerFile = int64(size)
	}
}

func WithLogger(logger log.Structured) Option {
	return func(queue *DiskQueue) {
		queue.logger = logger
	}
}
