package message

import (
	"sync"
)

var (
	pool = sync.Pool{
		New: func() interface{} {
			return new(Message)
		},
	}
)

func AcquireMsg() *Message {
	return pool.Get().(*Message)
}

func ReleaseMsg(msg *Message) {
	pool.Put(msg)
}
