package message

import (
	"bytes"
	"strings"
)

var (
	tskvEscaper = strings.NewReplacer(
		`\`, `\\`,
		"\t", `\t`,
		"\n", `\n`,
		"\r", `\r`,
		"\x00", `\0`,
		"=", `\=`,
	)

	backSlashStr = []byte(`\\`)
	tabStr       = []byte(`\t`)
	lfStr        = []byte(`\n`)
	crStr        = []byte(`\r`)
	nullStr      = []byte(`\0`)
	equalStr     = []byte(`\=`)
)

func tskvEscape(in string) (out string) {
	return tskvEscaper.Replace(in)
}

func tskvWriteEscaped(w *bytes.Buffer, in string) (err error) {
	_, err = tskvEscaper.WriteString(w, in)
	return
}

func tskvWriteEscapedBytes(w *bytes.Buffer, in []byte) {
	for _, r := range in {
		switch r {
		case '\\':
			w.Write(backSlashStr)
		case '\t':
			w.Write(tabStr)
		case '\n':
			w.Write(lfStr)
		case '\r':
			w.Write(crStr)
		case '\x00':
			w.Write(nullStr)
		case '=':
			w.Write(equalStr)
		default:
			w.WriteByte(r)
		}
	}
}
