package logbroker

type Stat struct {
	// Inflight is count of message currently in flight.
	Inflight uint64
	// Errors count
	Errors uint64
	// Successfully written messages
	Written uint64
}

func (s *Stat) Merge(another Stat) {
	s.Errors += another.Errors
	s.Inflight += another.Inflight
	s.Written += another.Written
}

type LbStat struct {
	MemQSize  int
	DiskQSize int
	MemStat   Stat
	DiskStat  Stat
}
