#! /bin/bash

# NginxHost="${NGINX_HOST:-_}"
# NginxPort="${NGINX_PORT:-8080}"

# if [[ ! -v NGINX_HOST ]]; then
#   echo "NGINX_HOST not set"
# elif [[ -z "${NGINX_HOST}" ]]; then
#   echo "NGINX_HOST not set"
# else
#   sed -i "s/# //g" /etc/nginx/sites-available/default
#   sed -i "s/server_name _;/server_name ${NGINX_HOST};/g" /etc/nginx/sites-available/default
# fi

# if [[ ! -v NGINX_PORT ]]; then
#   echo "NGINX_HOST not set"
# if [[ -z "${NGINX_PORT}" ]]; then
#   echo "NGINX_PORT not set"
# else
#   sed -i "s/listen 8080;/listen ${NGINX_PORT};/g" /etc/nginx/sites-available/default
#   sed -i "s/listen \[::\]:8080;/listen [::]:${NGINX_PORT};/g" /etc/nginx/sites-available/default
# fi

# echo "DB = \"postgresql://${DB_USER}:${DB_PASS}@${DB_HOST}:${DB_PORT}/${DB_NAME}\"" > /etc/ivre.conf 
# echo "DB_FLOW = \"neo4j://localhost:7474/db/data/\"" >> /etc/ivre.conf

# sed -i "s/server_name _;/server_name ${NginxHost};/g" /etc/nginx/sites-available/default
# sed -i "s/listen 8080;/listen ${NginxPort};/g" /etc/nginx/sites-available/default
# sed -i "s/listen \[::\]:8080;/listen [::]:${NginxPort};/g" /etc/nginx/sites-available/default

# ssl certs
mkdir /etc/nginx/ssl
if [[ -d "/cert_key" ]]; then
	echo "Nginx ssl certificates presented."
	cp /cert_key/private.key /etc/nginx/ssl/nginx_debby_agent.key
	cp /cert_key/cert.pem /etc/nginx/ssl/nginx_debby_agent.crt
else
	echo "No Nginx ssl certificates presented."
	echo "Generating selfsigned certificate"
	openssl req -new -newkey rsa:4096 -days 365 -nodes -x509 \
	                 -subj "/O=DebbyAgent/CN=*" \
	                 -keyout /etc/nginx/ssl/nginx_debby_agent.key \
	                 -out /etc/nginx/ssl/nginx_debby_agent.crt
fi

# loadbase ssh key
mkdir /root/.ssh
if [[ -f "/cert_key/loadbase.key" ]]; then
	echo "Copying loadbase ssh key."
	cp /cert_key/loadbase.key /root/.ssh/debby_ssh_key_checker.key
	chmod 400 /root/.ssh/debby_ssh_key_checker.key
fi

# Replace nginx port for custom from $NGINX_PORT env var
if [ -z $NGINX_PORT ]; then 
	echo "custom NGING PORT not set"; 
else 
	sed -i "s/443 ssl/$NGINX_PORT ssl/g" /tmp/file; 
fi

exec /usr/bin/supervisord -c /etc/supervisor/conf.d/supervisord.conf
