from __future__ import unicode_literals, absolute_import, print_function

from app.api.v1.engines import new_engine
from app.api.v1 import tasks

from app.settings import ENGINES
from app.settings import STATE_PENDING, STATE_IN_PROGRESS
from app.settings import STATE_CANCELED, STATE_FINISHED
from app.settings import CHECK_AUTH
from app import db
from app.auth import authenticate

import uuid
import json
from flask import jsonify, request, Blueprint
from app.api.v1 import tasks
import sys
import time
import logging


module = Blueprint('api_v1', __name__, url_prefix='/api/v1')


# CHECK AUTH TOKEN PRESENCE AND CORRECTNESS !!!
@module.before_request
def before_request():
    if CHECK_AUTH:
        auth_token = request.headers.get('X-AUTH-TOKEN')
        ok, msg = authenticate(auth_token)
        if not ok:
            return jsonify({'status':'error', 'message':msg})
    
    return None

@module.route('/scans', methods=['POST'])
def create_scan():
    # TODO: FIX DAT TRICK
    req_json = request.json
    if not isinstance(req_json, dict):
        req_json = json.loads(request.json)

    # check request data
    if req_json is None:
        return jsonify({'status':'error', 'message':'json object does not present'})
    if not isinstance(req_json, dict): 
        return jsonify({'status':'error', 'message':'invalid json format'})
    
    # Check engine
    engine_name = req_json.get('engine')
    if engine_name is None:
        return jsonify({'status':'error', 'message':'engine not specified'})
    if not isinstance(engine_name, str) and not isinstance(engine_name, unicode): 
        return jsonify({'status':'error', 'message':'invalid engine format'})
    if engine_name not in ENGINES:
        return jsonify({'status':'error', 'message':'unknown engine specified'})

    # check profile 
    profile = req_json.get('profile')
    if profile is None:
        return jsonify({'status':'error', 'message':'profile not specified'})
    if not isinstance(profile, str) and not isinstance(engine_name, unicode): 
        return jsonify({'status':'error', 'message':'invalid profile format'})

    engine = new_engine(engine_name)
    task_uuid = engine.create_task(profile, save_to_db=False)
    tasks.run_scan.apply_async((task_uuid, engine_name, profile))

    logging.warning("[+] POST /scans. engine_name: {}. task_uuid: {}".format(engine_name, task_uuid))

    return jsonify({'status':'ok', 'task_uuid':task_uuid})

@module.route('/scans/<task_uuid>', methods=['GET'])
def get_scan(task_uuid):
    # check uuid format
    try:
        uuid.UUID(task_uuid)
    except ValueError:
        return jsonify({'status':'error', 'message':'incorrect task_uuid format'})

    # cancel scan process
    engine = new_engine()
    res = engine.get_info(task_uuid)

    # get ivre results
    if res['status'] == 'ok':
        eng_name = res['task_info']['engine']
        if eng_name in ENGINES:
            engine = new_engine(eng_name)
            res = engine.get_info(task_uuid)

    logging.warning("GET /scans/<task_uuid>. task_uuid: {}. res['status']: {}.".format(task_uuid, res['status']))

    return jsonify(res)

@module.route('/scans/<task_uuid>', methods=['DELETE'])
def stop_scan(task_uuid):
    # check uuid format
    try:
        uuid.UUID(task_uuid)
    except ValueError:
        return jsonify({'status':'error', 'message':'incorrect task_uuid format'})

    # cancel scan process
    engine = new_engine()
    res = engine.cancel_scan(task_uuid)

    return jsonify(res)

@module.route('/scans', methods=['GET'])
def info_count():
    
    count_dict = {
        STATE_PENDING: 0,
        STATE_IN_PROGRESS: 0,
        STATE_FINISHED: 0,
        STATE_CANCELED: 0,
    }

    tasks = db.TaskInfo.select(db.TaskInfo.state).execute()
    for task in tasks:
        count_dict[task.state] += 1
    
    return jsonify({'status':'ok', 'results':count_dict})
