from __future__ import unicode_literals, absolute_import, print_function

# from app.settings import ENGINE_ZMAP, ENGINE_MASSCAN, ENGINE_IVRE
from app.settings import ENGINE_NMAP, ENGINE_SSH_KEY_CHECKER
from app.settings import ENGINE_CLICKHOUSECHECKER, ENGINE_MONGO_CHECKER, ENGINE_REDIS_CHECKER
from app.settings import ENGINE_IPMI_CHECKER, ENGINE_DIRECT_TRUST_IFRAME_CHECKER
from app.settings import ENGINE_AUTO_RU_IFRAME_CHECKER, ENGINE_REALTY_IFRAME_CHECKER
from app.settings import ENGINE_PAY_IFRAME_CHECKER
from app.settings import ENGINE_DOCKER_CHECKER
from app.settings import ENGINE_ZOOKEEPER_CHECKER

from app.api.v1.engines.base_engine import BaseEngine
from app.api.v1.engines.nmap_engine import NmapEngine
# from app.api.v1.engines.zmap_engine import ZmapEngine
# from app.api.v1.engines.ivre_engine import IvreEngine
# from app.api.v1.engines.masscan_engine import MasscanEngine
from app.api.v1.engines.mongo_checker_engine import MongoCheckerEngine
from app.api.v1.engines.redis_checker_engine import RedisCheckerEngine
from app.api.v1.engines.clickhousechecker_engine import ClickHouseCheckerEngine
from app.api.v1.engines.ipmi_checker_engine import IPMICheckerEngine
from app.api.v1.engines.direct_trust_iframe_checker_engine import DirectTrustIframeCheckerEngine
from app.api.v1.engines.ssh_key_checker_engine import SshKeyCheckerEngine
from app.api.v1.engines.auto_ru_iframe_checker_engine import AutoruIframeCheckerEngine
from app.api.v1.engines.realty_iframe_checker_engine import RealtyIframeCheckerEngine
from app.api.v1.engines.pay_iframe_checker_engine import PayIframeCheckerEngine
from app.api.v1.engines.docker_checker_engine import DockerCheckerEngine
from app.api.v1.engines.zookeeper_checker_engine import ZookeeperCheckerEngine


def new_engine(engine=None):
    if not engine:
        return BaseEngine()
    elif engine == ENGINE_NMAP:
        return NmapEngine()
    # elif engine == ENGINE_ZMAP:
    #     return ZmapEngine()
    # elif engine == ENGINE_MASSCAN:
    #     return MasscanEngine()
    # elif engine == ENGINE_IVRE:
    #     return IvreEngine()
    elif engine == ENGINE_DIRECT_TRUST_IFRAME_CHECKER:
        return DirectTrustIframeCheckerEngine()
    elif engine == ENGINE_CLICKHOUSECHECKER:
        return ClickHouseCheckerEngine()
    elif engine == ENGINE_MONGO_CHECKER:
        return MongoCheckerEngine()
    elif engine == ENGINE_REDIS_CHECKER:
        return RedisCheckerEngine()
    elif engine == ENGINE_IPMI_CHECKER:
        return IPMICheckerEngine()
    elif engine == ENGINE_SSH_KEY_CHECKER:
        return SshKeyCheckerEngine()
    elif engine == ENGINE_AUTO_RU_IFRAME_CHECKER:
        return AutoruIframeCheckerEngine()
    elif engine == ENGINE_REALTY_IFRAME_CHECKER:
        return RealtyIframeCheckerEngine()
    elif engine == ENGINE_PAY_IFRAME_CHECKER:
        return PayIframeCheckerEngine()
    elif engine == ENGINE_DOCKER_CHECKER:
        return DockerCheckerEngine()
    elif engine == ENGINE_ZOOKEEPER_CHECKER:
        return ZookeeperCheckerEngine()
    else:
        raise NotImplementedError()

