from __future__ import unicode_literals, absolute_import, print_function

import os
import shlex
import json
import traceback

from app import db
from .base_engine import BaseEngine
from app.settings import TMP_DIR_PATH
from app.settings import ENGINE_MONGO_CHECKER
from app.settings import STATE_CANCELED, STATE_FINISHED


class MongoCheckerEngine(BaseEngine):
    def __init__(self):
        self.engine = ENGINE_MONGO_CHECKER
        self.tmp_dir_path = TMP_DIR_PATH
        self.process_results_on_cancel = False
        self.engine_runner = os.path.join(os.getcwd(), 'app', 'engines', 'mongo_checker.py')

    def _prepare_args(self, task_uuid, profile):
        tmp_file_path = os.path.join(self.tmp_dir_path, task_uuid)
        args = ['python', self.engine_runner, '-o', tmp_file_path] + shlex.split(profile['args'])
        return args

    def get_info(self, task_uuid):
        task_info = db.get_task_info(task_uuid)

        if task_info is None:
            return {'status':'error', 'message':'unknown task_uuid'}
            
        if task_info['state'] in [STATE_FINISHED, STATE_CANCELED]:

            try:
                tmp_file_path = os.path.join(self.tmp_dir_path, task_uuid)
                f = open(tmp_file_path, 'r')
                results = f.read()
                f.close()
                os.remove(tmp_file_path)
                task_info['results'] = json.loads(results)
            except IOError:
                task_info['results'] = None
            except Exception:
                traceback.print_exc()
                task_info['results'] = None

        del task_info['pid']
        return {'status':'ok', 'task_info':task_info}

    def _process_results(self, task_uuid):
        task_info = db.get_task_info(task_uuid)
        if not task_info:
            print('[+] nmap_engine. process_results. db.get_task_info(task_uuid) returned None. task_uuid: {}'.format(task_uuid))
            return

        db.set_results(task_uuid=task_uuid, results=None, state=STATE_FINISHED)
        return
