from __future__ import unicode_literals, absolute_import, print_function

from app.settings import AUTH_TOKEN_LENGTH, AUTH_TOKEN_ALPHABET
from app.db import AuthToken
import random

def authenticate(x_auth_token):

    if not x_auth_token:
        return False, 'X-AUTH-TOKEN not present'

    auth_token = AuthToken.select()

    if len(auth_token) == 0:
        return False, 'Auth token not configured'
    
    if auth_token[-1].value != x_auth_token:
        return False, 'Incorrect auth token'
    
    return True, None

def gen_new_token():
    """ Designed to be called from manage.py """

    global AUTH_TOKEN_LENGTH
    global AUTH_TOKEN_ALPHABET

    new_token = ''.join(
        random.choice(AUTH_TOKEN_ALPHABET) for _ in range(AUTH_TOKEN_LENGTH)
        )

    AuthToken.create(value=new_token)
    return new_token

def get_current_token():
    """ Designed to be called from manage.py """

    return AuthToken.select()

def set_token(token):
    """ Designed to be called from manage.py """

    if len(token) != AUTH_TOKEN_LENGTH:
        return False, "Length of token must be {} symbols".format(AUTH_TOKEN_LENGTH)
    
    ok_symbols = True
    for s in token:
        if s not in AUTH_TOKEN_ALPHABET:
            ok_symbols = False
            break

    if not ok_symbols:
        return False, "Illegal symbols met"

    AuthToken.create(value=token)
    return True, token
