#!/usr/bin/env python

from selenium import webdriver
from selenium.common.exceptions import NoSuchElementException

import argparse
import base64
import json
import time


BASE64MEGAURL = "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"
MEGAURL = base64.b64decode(BASE64MEGAURL)


def parse_args():
    parser = argparse.ArgumentParser()
    parser.add_argument("-l", "--login", help="Passport login")
    parser.add_argument("-p", "--password", help="Password of passport account")
    parser.add_argument("-o","--output", help="Output file name")
    return parser.parse_args()

def check(login,password):
    url = 'http://selenium:selenium@sg.yandex-team.ru:4444/wd/hub'

    target_info = {
        "success_auth": False,
        "trusted_iframe": False,
        "trusted_iframe2": False,
        # "yooMoneySDK": False,
        "error": None,
        "host": "pay.yandex.ru",
        "url": "https://pay.yandex.ru",
    }

    try:
        driver = webdriver.Remote(
            command_executor = url,
            desired_capabilities = {
                "browserName": "chrome",
                "browserVersion": "91.0"
            }
        )
        driver.get(MEGAURL)

        # Login
        time.sleep(2)
        driver.implicitly_wait(10)
        driver.find_element_by_css_selector('[data-t="field:input-login"]').send_keys(login)
        driver.find_element_by_xpath('//div[@class="passp-button passp-sign-in-button"]/button').click()
        time.sleep(2)
        driver.implicitly_wait(10)
        driver.find_element_by_id('passp-field-passwd').send_keys(password)
        driver.find_element_by_xpath('//div[@class="passp-button passp-sign-in-button"]/button').click()

        # driver.save_screenshot("1.png")
        # driver.find_element_by_class_name("bind-card-frame__content")
        # driver.get(MEGAURL)

        # SKIPPING ADDITIONAL EMAIL FORM
        try:
            time.sleep(2)
            driver.implicitly_wait(10)
            driver.find_element_by_xpath('//div[@data-t="email_skip"]/button').click()
        except NoSuchElementException as e:
            pass

        time.sleep(2)
        driver.implicitly_wait(10)
        iframe1 = driver.find_element_by_xpath('//div[@class="bind-card-frame__content"]/iframe')
        if iframe1.get_property("src").startswith("https://trust.yandex.ru/web/binding?"):
            target_info['trusted_iframe'] = True
            target_info['success_auth'] = True

        time.sleep(2)
        driver.implicitly_wait(10)
        driver.switch_to.frame(iframe1)

        time.sleep(2)
        driver.implicitly_wait(10)
        iframe2 = driver.find_element_by_class_name("card-form__frame")
        if iframe2.get_property("src").startswith("https://diehard.yandex.ru/web/card_form?"):
            target_info['trusted_iframe2'] = True
        else:
            target_info["error"] = "Target iframe src has an unexpected value"

    except Exception as e:
        target_info["error"] = repr(e) + ": " + e.msg
    
    finally:
        driver.close()

    return target_info

def main():
    args = parse_args()
    result = None
    for i in range(3):
        result = check(args.login,args.password)
        if result["trusted_iframe"] and result["trusted_iframe2"]:
            break
        time.sleep(15)

    results = [result]
  
    if not args.output:
        print(json.dumps(results))
    else:
        with open(args.output, 'w') as f:
            f.write(json.dumps(results))

if __name__ == '__main__':
    main()
