#!/usr/bin/env python

from selenium import webdriver
from selenium.common.exceptions import NoSuchElementException

import argparse
import json
import time

def parse_args():
    parser = argparse.ArgumentParser()
    parser.add_argument("-l", "--login", help="Passport login")
    parser.add_argument("-p", "--password", help="Password of passport account")
    parser.add_argument("-o","--output", help="Output file name")
    return parser.parse_args()


def check(login, password):
    
    target_info = {
            "success_auth": False,
            "trusted_iframe": False,
            "yooMoneySDK": False,
            "error": None,
            "host": "realty.yandex.ru",
            "url": "https://realty.yandex.ru/",
    }
    
    try:
        url = 'http://selenium:selenium@sg.yandex-team.ru:4444/wd/hub'
        driver = webdriver.Remote(
            command_executor = url,
            desired_capabilities = {
                "browserName": "chrome",
                "browserVersion": "91.0"
            }
        )
        # driver = webdriver.Firefox()
        driver.get("https://realty.yandex.ru/")
        # Login
        time.sleep(2)
        driver.implicitly_wait(10)
        driver.find_element_by_xpath('//div[contains(@class, "NavBarUserMenu__container")]/a[contains(@class, "LoginButton")]').click()
        time.sleep(2)
        driver.implicitly_wait(10)
        driver.find_element_by_id('passp-field-login').send_keys(login)
        time.sleep(2)
        driver.implicitly_wait(10)
        driver.find_element_by_xpath('//div[@class="passp-button passp-sign-in-button"]/button').click()
        time.sleep(2)
        driver.implicitly_wait(10)
        driver.find_element_by_id('passp-field-passwd').send_keys(password)
        time.sleep(2)
        driver.implicitly_wait(10)
        driver.find_element_by_xpath('//div[@class="passp-button passp-sign-in-button"]/button').click()

        # SKIPPING ADDITIONAL EMAIL FORM
        try:
            time.sleep(2)
            driver.implicitly_wait(10)
            driver.find_element_by_xpath('//div[@data-t="email_skip"]/button').click()
        except NoSuchElementException as e:
            pass

        time.sleep(2)
        driver.implicitly_wait(10)
        driver.find_element_by_xpath('//div[@class="WalletBar"]/button').click()
        target_info["success_auth"] = True
        time.sleep(2)
        driver.implicitly_wait(10)
        driver.find_element_by_xpath('//div[contains(@class, "WalletAmountScreen__inputWrapper")]/button').click()
        time.sleep(2)
        driver.implicitly_wait(10)
        frame = driver.find_element_by_name('YKassaCardForm')
        if frame.get_attribute('src') == 'https://realty.yandex.ru/payment/':
            target_info['trusted_iframe'] = True

        time.sleep(2)
        driver.implicitly_wait(10)
        driver.switch_to.frame(frame)
        time.sleep(2)
        driver.implicitly_wait(10)
        sdkSrc = driver.find_element_by_xpath('//body[@class=" yoomoney-checkout_visible"]/script[1]').get_attribute('src')
        if sdkSrc == 'https://static.yoomoney.ru/checkout-ui/v1/checkout-ui.js':
            target_info['yooMoneySDK'] = True

    except Exception as e:
        target_info["error"] = repr(e) + ": " + e.msg
    
    finally:
        driver.close()
    
    return target_info

def main():
    args = parse_args()
    
    result = None
    for i in range(3):
        result = check(args.login,args.password)
        if result["trusted_iframe"]:
            break
        time.sleep(15)
    
    results = [result]

    if not args.output:
        print(json.dumps(results))
    else:
        with open(args.output, 'w') as f:
            f.write(json.dumps(results))

if __name__ == '__main__':
    main()