from __future__ import unicode_literals, absolute_import, print_function

import os
import string

AGENT_CONCURRENCY = 5
_AGENT_CONCURRENCY = os.getenv('AGENT_CONCURRENCY', None)
if _AGENT_CONCURRENCY and _AGENT_CONCURRENCY.isdigit():
	AGENT_CONCURRENCY = int(_AGENT_CONCURRENCY)

# tmp results dir
TMP_DIR_PATH = os.path.join('/tmp', 'debby')
# TODO: check that strange bug on aws ubuntu...
try:
    if not os.path.exists(TMP_DIR_PATH):
        os.makedirs(TMP_DIR_PATH)
except OSError:
    pass

# directory for ivre templates
IVRE_TEMPLATES_DIR = os.path.join('/tmp', 'ivre_templates')
# TODO: check that strange bug on aws ubuntu...
try:
    if not os.path.exists(IVRE_TEMPLATES_DIR):
        os.makedirs(IVRE_TEMPLATES_DIR)
except OSError:
    pass

# {
#     "nmap": {},
#     "pings": {},
#     "scans": {},
#     "osdetect": {},
#     "traceroute": {},
#     "resolve": {},
#     "verbosity": {},
#     "ports": {},
#     "host_timeout": {},
#     "script_timeout": {},  
#     "scripts_categories": {}
#     "scripts_exclude": {}
#     "scripts_force": {},
#     "extra_options": {},
# }

# Scan states
STATE_PENDING = 'pending'
STATE_IN_PROGRESS = 'in progress'
STATE_CANCELED = 'canceled'
STATE_FINISHED = 'finished'

# Supported engines
ENGINE_NMAP = 'nmap'
ENGINE_ZMAP = 'zmap'
ENGINE_IVRE = 'ivre'
ENGINE_MASSCAN = 'masscan'
ENGINE_CLICKHOUSECHECKER = 'clickhousechecker'
ENGINE_MONGO_CHECKER = 'mongo_checker'
ENGINE_REDIS_CHECKER = 'redis_checker'
ENGINE_DOCKER_CHECKER = 'docker_checker'
ENGINE_ZOOKEEPER_CHECKER = 'zookeeper_checker'
ENGINE_IPMI_CHECKER = 'ipmi_checker'
ENGINE_DIRECT_TRUST_IFRAME_CHECKER = 'direct_trust_iframe_checker'
ENGINE_AUTO_RU_IFRAME_CHECKER = 'auto_ru_iframe_checker'
ENGINE_REALTY_IFRAME_CHECKER = 'realty_iframe_checker'
ENGINE_PAY_IFRAME_CHECKER = 'pay_iframe_checker'
ENGINE_SSH_KEY_CHECKER = 'ssh_key_checker'
ENGINES = [
	ENGINE_NMAP, ENGINE_CLICKHOUSECHECKER, ENGINE_MONGO_CHECKER, ENGINE_SSH_KEY_CHECKER,
	ENGINE_REDIS_CHECKER, ENGINE_IPMI_CHECKER, ENGINE_DIRECT_TRUST_IFRAME_CHECKER,
        ENGINE_AUTO_RU_IFRAME_CHECKER, ENGINE_REALTY_IFRAME_CHECKER, ENGINE_PAY_IFRAME_CHECKER,
        ENGINE_DOCKER_CHECKER, ENGINE_ZOOKEEPER_CHECKER
]

# host states
STATE_HOST_UP = 'up'
STATE_HOST_DOWN = 'down'

# port states
STATE_PORT_OPEN = 'open'
STATE_PORT_OPEN_FILTERED = 'open|filtered'
STATE_PORT_FILTERED = 'filtered'
STATE_PORT_CLOSED= 'closed'

# ----------------------
# --- Authentication ---
# ----------------------

AUTH_TOKEN_ALPHABET = string.ascii_uppercase + string.ascii_lowercase
AUTH_TOKEN_ALPHABET += string.digits

AUTH_TOKEN_LENGTH = 64
AUTH_TOKEN = None
CHECK_AUTH = os.getenv("CHECK_AUTH", "1") in ["1", "True", "TRUE", "t"]
