from __future__ import unicode_literals, absolute_import, print_function

import psutil
import pytz
import tzlocal
import calendar
import datetime

def is_process_alive(pid):
    """
    checks if process is alive
    Input:
        (int)pid
    Output:
        (boolean)is_alive
    """
    try:
        p = psutil.Process(pid)
        if p.is_running() and p.status() != psutil.STATUS_ZOMBIE:
            return True
        else:
            return False
    except psutil.NoSuchProcess:
        return False

# ------------------
# --- Time Hacks ---
# ------------------

def datetime_2_timestamp(dt):
    return calendar.timegm(dt.replace(tzinfo=pytz.utc).timetuple())


def timestamp_2_datetime(ts):
    return datetime.datetime.fromtimestamp(ts)


def datetime_msk_2_timestamp_utc(dt):
    utc_now = datetime.datetime.utcnow().replace(microsecond=0)
    msk_now = utc_dt_to_msk_dt(utc_now)
    delta = msk_now - utc_now
    dt = dt - delta
    return calendar.timegm(dt.timetuple())


def timestamp_utc_2_datetime_msk(ts):
    return utc_dt_to_msk_dt(datetime.datetime.utcfromtimestamp(ts))


def utc_dt_to_msk_dt(utc_dt):
    return utc_dt.replace(tzinfo=pytz.utc).astimezone(pytz.timezone('Europe/Moscow')).replace(tzinfo=None)


def msk_dt_to_utc_dt(utc_dt):
    return utc_dt.replace(tzinfo=pytz.timezone('Europe/Moscow')).astimezone(pytz.utc).replace(tzinfo=None)


# Local time hacks


def local_dt_2_msk_dt(dt):
    local_tz = tzlocal.get_localzone()
    return dt.replace(tzinfo=local_tz).astimezone(pytz.timezone('Europe/Moscow')).replace(tzinfo=None)


def local_dt_2_utc_dt(dt):
    local_tz = tzlocal.get_localzone()
    return dt.replace(tzinfo=local_tz).astimezone(pytz.utc).replace(tzinfo=None)

def local_ts_2_msk_ts(local_ts):
    local_dt = timestamp_2_datetime(local_ts)
    msk_dt = local_dt_2_msk_dt(local_dt)
    msk_ts = datetime_2_timestamp(msk_dt)
    return msk_ts
