from __future__ import unicode_literals, absolute_import, print_function

import sys
import uuid
import os

from celery.bin import worker

from app import create_app
from app.auth import gen_new_token, get_current_token, set_token as set_token_imp
from app.api.v1.tasks import app as celery_app
from app.settings import AGENT_CONCURRENCY


def run_celery():
    wrk = worker.worker(app=celery_app)
    options = {
        'loglevel': 'INFO',
        'traceback': True,
        'hostname': str(uuid.uuid4()),
        'concurrency': AGENT_CONCURRENCY
    }
    wrk.run(**options)


def run_debby():
    debby_app = create_app()
    debby_app.run(host='::', port=8080, debug=True)


def gen_token():
    new_token = gen_new_token()
    print('[+] Generated new auth token: {}'.format(new_token))


def get_cur_token():
    auth_token = get_current_token()

    if len(auth_token) == 0:
        print('Auth token not configured!')
    else:
        print('Success. Current token: {}'.format(auth_token[-1].value))


def set_token(token):
    ok, msg = set_token_imp(token)
    if not ok:
        print('Incorrect format: {}'.format(msg))
    else:
        print('New token: {}'.format(msg))


def help():
    print('[+] --------------------------------')
    print('[+]   python manage.py new token')
    print('[+]   python manage.py get token')
    print('[+]   python manage.py set token <value>')
    print('[+]   python manage.py run celery')
    print('[+]   python manage.py run debby')
    print('[+] --------------------------------')


def main():
    if len(sys.argv) == 3:
        if sys.argv[1] == 'run':
            if sys.argv[2] == 'celery':
                run_celery()
                return
            elif sys.argv[2] == 'debby':
                run_debby()
                return
        elif sys.argv[1] == 'new':
            if sys.argv[2] == 'token':
                gen_token()
                return
        elif sys.argv[1] == 'get':
            if sys.argv[2] == 'token':
                get_cur_token()
                return
    elif len(sys.argv) == 4:
        if sys.argv[1] == 'set':
            if sys.argv[2] == 'token':
                set_token(sys.argv[3])
                return
    help()

if __name__ == '__main__':
    main()
