

import sys
import uuid
from celery.bin import beat, worker
from future.utils import iteritems
from app.db.db import init_tables, drop_tables, refresh_tables, new_session
from app.db.models import DebbyPolicy, DebbyTag
from app.tasks import celery_app

def run_celery_beat():
    beat_ = beat.beat(app=celery_app)
    options = {
        'loglevel': 'WARNING',
        'traceback': True,
        'hostname': str(uuid.uuid4()),
        'concurrency': 2,
        # 'logfile': 'log'
    }
    beat_.run(**options)

def run_celery_worker():
    worker_ = worker.worker(app=celery_app)
    options = {
        'loglevel': 'WARNING',
        'traceback': True,
        'hostname': str(uuid.uuid4()),
        'concurrency': 2,
        # 'logfile': 'log'
    }
    worker_.run(**options)

def fill_db():
    s = new_session()
    dp = DebbyPolicy(name='policy_1', ports='80', scan_type='tcp')
    s.add(dp)
    dt1 = DebbyTag(value='INTERNAL')
    s.add(dt1)
    dt2 = DebbyTag(value='EXTERNAL')
    s.add(dt2)
    s.commit()
    s.close()

COMMANDS = {
    'initdb': init_tables,
    'dropdb': drop_tables,
    'refreshdb': refresh_tables,
    'filldb': fill_db,
    'runbeat': run_celery_beat,
    'runworker': run_celery_worker,
}

def help():
    print('[+] ------------------------------')
    print('[+] ----- Available commands -----')
    print('[+] ------------------------------')
    for (cmd, _) in iteritems(COMMANDS):
        print('[+]    python {} {}'.format(sys.argv[0], cmd))
    print('[+] ------------------------------')
    return

def main():
    global COMMANDS

    if len(sys.argv) != 2:
        help()
        return

    for (cmd, func) in iteritems(COMMANDS):
        if sys.argv[1] == cmd:
            func()
            return
    
    help()
    return

if __name__ == '__main__':
    main()
    