
from flask import Flask, redirect, url_for, jsonify
from flask_wtf.csrf import CSRFProtect as CsrfProtect

from app import agents
from app import macros
from app import scans
from app import namespaces
from app import policies
from app import projects
from app.api import v1 as api_v1
from app.unistat import get_unistat
from app.settings import SECRET_KEY


def create_app(test_config=None):
    # create and configure the app
    app = Flask(__name__, instance_relative_config=True)
    app.config.from_mapping(
        SECRET_KEY=SECRET_KEY
    )

    # CSRF Protection
    csrf = CsrfProtect()
    csrf.init_app(app)
    csrf.exempt(api_v1.bp)

    # if test_config is None:
    #     # load the instance config, if it exists, when not testing
    #     app.config.from_pyfile('config.py', silent=True)
    # else:
    #     # load the test config if passed in
    #     app.config.from_mapping(test_config)

    # # ensure the instance folder exists
    # try:
    #     os.makedirs(app.instance_path)
    # except OSError:
    #     pass

    app.register_blueprint(namespaces.bp)
    app.register_blueprint(scans.bp)
    app.register_blueprint(policies.bp)
    app.register_blueprint(agents.bp)
    app.register_blueprint(macros.bp)
    app.register_blueprint(projects.bp)
    app.register_blueprint(api_v1.bp)

    @app.route('/')
    def main():
        # return redirect(url_for('projects.projects_main'))
        return redirect(url_for('namespaces.namespaces_main'))

    @app.route('/unistat')
    def unistat():
        return jsonify(get_unistat())

    return app


application = create_app()
