

from app.agents.debby_agent_client import DebbyAgentClient
from app.agents.molly_client import MollyAgentClient
from app.agents.openvas_client import OpenVASAgentClient
from app.agents.openvas_2_client import OpenVASAgentClient as OpenVAS2AgentClient
from app.db.db import new_session
from app.db.models import RelationAgentTag, DebbyTag
from app.settings import AGENT_CLIENT_TYPE_DEBBY, AGENT_CLIENT_TYPE_MOLLY
from app.settings import AGENT_CLIENT_TYPE_OPENVAS, AGENT_CLIENT_TYPE_OPENVAS_2


def new_agent_client(agent, type_=None):

    # determine agent client type
    if type_ is None:
        s = new_session()
        tags = s.query(DebbyTag.value).filter(RelationAgentTag.tag_id == DebbyTag.id)\
                                      .filter(RelationAgentTag.agent_id == agent.id).all()
        s.close()
        tag_values = [value for (value,) in tags]

        if AGENT_CLIENT_TYPE_MOLLY in tag_values:
            type_ = AGENT_CLIENT_TYPE_MOLLY
        elif AGENT_CLIENT_TYPE_OPENVAS in tag_values:
            type_ = AGENT_CLIENT_TYPE_OPENVAS
        elif AGENT_CLIENT_TYPE_OPENVAS_2 in tag_values:
            type_ = AGENT_CLIENT_TYPE_OPENVAS_2
        else:
            type_ = AGENT_CLIENT_TYPE_DEBBY

    # return appropriate AgentClient object
    if type_ == AGENT_CLIENT_TYPE_DEBBY:
        return DebbyAgentClient(agent)
    if type_ == AGENT_CLIENT_TYPE_MOLLY:
        return MollyAgentClient(agent)
    if type_ == AGENT_CLIENT_TYPE_OPENVAS:
        return OpenVASAgentClient(agent)
    if type_ == AGENT_CLIENT_TYPE_OPENVAS_2:
        return OpenVAS2AgentClient(agent)
    else:
        raise ValueError('Unknown agent client')
