

from app.db.db import new_session
from app.db.models import DebbyTag, DebbyAgent, RelationAgentTag
from app.settings import API_TAG


def create_tag_if_not_exists(tag_name, session_=None):
    if session_:
        session = session_
    else:
        session = new_session()

    t = session.query(DebbyTag).filter(DebbyTag.value == tag_name).first()
    if not t:
        session.add(DebbyTag(value=tag_name))
        session.commit()

    if not session_:
        session.close()

    return


def get_known_tags(session_=None):
    if session_:
        session = session_
    else:
        session = new_session()

    tags = session.query(DebbyTag).all()

    if not session_:
        session.close()

    return tags


def get_api_available_agents(session_=None):
    if session_:
        session = session_
    else:
        session = new_session()

    create_tag_if_not_exists(API_TAG)
    agents_tags = session.query(DebbyAgent.id, DebbyAgent.name, DebbyTag.value)\
                         .join(RelationAgentTag, DebbyAgent.id == RelationAgentTag.agent_id)\
                         .join(DebbyTag, RelationAgentTag.tag_id == DebbyTag.id).all()

    if not session_:
        session.close()

    all_agents = dict()
    for agent_tag in agents_tags:

        agent_id = agent_tag[0]
        agent_name = agent_tag[1]
        tag_value = agent_tag[2]

        agent_info = all_agents.get(agent_id)
        if agent_info:
            agent_info['tags'].append(tag_value)
        else:
            all_agents[agent_id] = {
                'id': agent_id,
                'name': agent_name,
                'tags': list()
            }

    available_api_agents = list([a for a in list(all_agents.values()) if API_TAG in a['tags']])

    return available_api_agents
