from app.validators import DebbyValidateException


def validate_agent_data(request, known_tags):
    name = request.form.get("agent_name")
    if len(name) == 0 or len(name) > 32:
        raise DebbyValidateException('Incorrect name length')

    try:
        max_jobs = int(request.form.get("agent_max_jobs"))
    except ValueError:
        raise DebbyValidateException('Incorrect max jobs value')

    spec_tags = request.form.getlist("agent_tags")
    try:
        spec_tags_ids = list([int(t.split(':')[0]) for t in spec_tags])
        known_tags_ids = list([t.id for t in known_tags])
        if not all([spec_tag_id in known_tags_ids for spec_tag_id in spec_tags_ids]):
            raise ValueError
    except ValueError:
        raise DebbyValidateException('Incorrect tag specified')

    # TODO: make it better
    address = request.form.get("agent_address")
    if len(address) == 0:
        raise DebbyValidateException('Incorrect address')

    return {
        'name': name,
        'address': address,
        'max_jobs': max_jobs,
        'spec_tags_ids': spec_tags_ids,
        'token': request.form.get("agent_token")
    }
