

from app.engines.ssh_key_checker_engine import SshKeyCheckerEngine
from app.engines.direct_trust_iframe_checker_engine import DirectTrustIframeCheckerEngine
from app.engines.auto_ru_iframe_checker import AutoruIframeCheckerEngine
from app.engines.realty_iframe_checker import RealtyIframeCheckerEngine
from app.engines.pay_iframe_checker import PayIframeCheckerEngine
from app.engines.nmap_engine import NmapEngine
from app.engines.clickhousechecker_engine import ClickHouseCheckerEngine
from app.engines.mongo_checker_engine import MongoCheckerEngine
from app.engines.redis_checker_engine import RedisCheckerEngine
from app.engines.ipmi_checker_engine import IPMICheckerEngine
from app.engines.molly_engine import MollyEngine
from app.engines.openvas_engine import OpenvasEngine
from app.engines.openvas_2_engine import OpenvasEngine as Openvas2Engine
from app.engines.docker_engine import DockerCheckerEngine
from app.engines.zookeeper_engine import ZookeeperCheckerEngine
from app.settings import ENGINE_NMAP, ENGINE_CLICKHOUSECHECKER, ENGINE_MONGO_CHECKER
from app.settings import ENGINE_REDIS_CHECKER, ENGINE_MOLLY, ENGINE_OPENVAS, ENGINE_OPENVAS_2
from app.settings import ENGINE_IPMI_CHECKER, ENGINE_SSH_KEY_CHECKER, ENGINE_PAY_IFRAME_CHECKER
from app.settings import ENGINE_DIRECT_TRUST_IFRAME_CHECKER, ENGINE_AUTO_RU_IFRAME_CHECKER
from app.settings import ENGINE_REALTY_IFRAME_CHECKER, ENGINE_DOCKER_CHECKER, ENGINE_ZOOKEEPER_CHECKER
from app.validators import DebbyValidateException


def new_engine(name):
    if name == ENGINE_NMAP:
        return NmapEngine
    elif name == ENGINE_CLICKHOUSECHECKER:
        return ClickHouseCheckerEngine
    elif name == ENGINE_MONGO_CHECKER:
        return MongoCheckerEngine
    elif name == ENGINE_REDIS_CHECKER:
        return RedisCheckerEngine
    elif name == ENGINE_MOLLY:
        return MollyEngine
    elif name == ENGINE_OPENVAS:
        return OpenvasEngine
    elif name == ENGINE_OPENVAS_2:
        return Openvas2Engine
    elif name == ENGINE_IPMI_CHECKER:
        return IPMICheckerEngine
    elif name == ENGINE_DIRECT_TRUST_IFRAME_CHECKER:
        return DirectTrustIframeCheckerEngine
    elif name == ENGINE_AUTO_RU_IFRAME_CHECKER:
        return AutoruIframeCheckerEngine
    elif name == ENGINE_REALTY_IFRAME_CHECKER:
        return RealtyIframeCheckerEngine
    elif name == ENGINE_PAY_IFRAME_CHECKER:
        return PayIframeCheckerEngine
    elif name == ENGINE_SSH_KEY_CHECKER:
        return SshKeyCheckerEngine
    elif name == ENGINE_DOCKER_CHECKER:
        return DockerCheckerEngine
    elif name == ENGINE_ZOOKEEPER_CHECKER:
        return ZookeeperCheckerEngine
    else:
        raise DebbyValidateException('Unknown Engine {}'.format(name))

